/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.agenda;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.agenda.AgendaTemplate;
import com.sun.star.wizards.agenda.AgendaWizardDialog;
import com.sun.star.wizards.agenda.CGAgenda;
import com.sun.star.wizards.agenda.TopicsControl;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.PathSelection;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.XPathSelectionListener;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Vector;

public class AgendaWizardDialogImpl
extends AgendaWizardDialog {
    static boolean running;
    AgendaTemplate agendaTemplate;
    private CGAgenda agenda;
    private TopicsControl topicsControl;
    private String[][] agendaTemplates;
    PathSelection myPathSelection;
    String sTemplatePath;
    String sUserTemplatePath;
    String sBitmapPath;
    String sPath;
    private FileAccess fileAccess1;
    private boolean filenameChanged = false;

    public AgendaWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public void startWizard() {
        running = true;
        try {
            this.agenda = new CGAgenda();
            Object object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.Writer/Wizards/Agenda", (boolean)false);
            this.agenda.readConfiguration(object, "cp_");
            this.agendaTemplate = new AgendaTemplate(this.xMSF, this.agenda, this.resources, (XTerminateListener)this);
            this.initializeTemplates();
            this.agendaTemplate.load(this.agendaTemplates[1][this.agenda.cp_AgendaType], new Vector());
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.topicsControl = new TopicsControl(this, this.xMSF, this.agenda);
            this.buildStep6();
            this.drawNaviBar();
            this.initializePaths();
            this.insertPathSelectionControl();
            XWindow xWindow = this.agendaTemplate.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)XWindowPeer.class, (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.addRoadmap();
            this.insertRoadMapItems(new String[]{this.resources.resStep1, this.resources.resStep2, this.resources.resStep3, this.resources.resStep4, this.resources.resStep5, this.resources.resStep6}, new int[]{1, 2, 3, 4, 5, 6}, new boolean[]{true, true, true, true, true, true});
            this.setMaxStep(6);
            this.makeDA();
            if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
                this.myPathSelection.initializePath();
            }
            this.executeDialog((XInterface)this.agendaTemplate.xFrame);
            this.removeTerminateListener();
            this.closeDocument();
            running = false;
        }
        catch (Exception exception) {
            this.removeTerminateListener();
            exception.printStackTrace();
            running = false;
            return;
        }
    }

    public void insertPathSelectionControl() {
        this.myPathSelection = new PathSelection(this.xMSF, (UnoDialog2)this, 0, 1);
        this.myPathSelection.insert(6, 97, 70, 205, (short)45, this.resources.reslblTemplatePath_value, true, "HID:41075", "HID:41076");
        this.myPathSelection.sDefaultDirectory = this.sUserTemplatePath;
        this.myPathSelection.sDefaultName = "myAgendaTemplate.ott";
        this.myPathSelection.sDefaultFilter = "writer8_template";
        this.myPathSelection.addSelectionListener((XPathSelectionListener)new myPathSelectionListener());
    }

    private void initializePaths() {
        try {
            this.sTemplatePath = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Template", (String)"share", (String)"/wizard");
            this.sUserTemplatePath = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Template", (String)"user", (String)"");
            this.sBitmapPath = FileAccess.combinePaths((XMultiServiceFactory)this.xMSF, (String)this.sTemplatePath, (String)"/wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
        }
    }

    private void checkSavePath() {
        if (this.agenda.cp_TemplatePath == null || this.agenda.cp_TemplatePath.equals("") || !this.getFileAccess().exists(FileAccess.getParentDir((String)this.agenda.cp_TemplatePath), false) || !this.getFileAccess().isDirectory(FileAccess.getParentDir((String)this.agenda.cp_TemplatePath))) {
            try {
                this.agenda.cp_TemplatePath = FileAccess.connectURLs((String)FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Work", (String)"", (String)""), (String)this.resources.resDefaultFilename);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void makeDA() {
        this.setControlProperty("listPageDesign", "StringItemList", this.agendaTemplates[0]);
        this.checkSavePath();
        UnoDataAware.attachListBox((Object)((Object)this.agenda), (String)"cp_AgendaType", (Object)this.listPageDesign, null, (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_IncludeMinutes", (Object)this.chkMinutes, null, (boolean)true).updateUI();
        UnoDataAware.attachEditControl((Object)((Object)this.agenda), (String)"cp_Title", (Object)this.txtTitle, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachDateControl((Object)((Object)this.agenda), (String)"cp_Date", (Object)this.txtDate, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachTimeControl((Object)((Object)this.agenda), (String)"cp_Time", (Object)this.txtTime, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachEditControl((Object)((Object)this.agenda), (String)"cp_Location", (Object)this.cbLocation, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowMeetingType", (Object)this.chkMeetingTitle, (DataAware.Listener)new RedrawListener("<meeting-type>"), (boolean)true);
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowRead", (Object)this.chkRead, (DataAware.Listener)new RedrawListener("<read>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowBring", (Object)this.chkBring, (DataAware.Listener)new RedrawListener("<bring>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowNotes", (Object)this.chkNotes, (DataAware.Listener)new RedrawListener("<notes>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowCalledBy", (Object)this.chkConvenedBy, (DataAware.Listener)new RedrawListener("<called-by>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowFacilitator", (Object)this.chkPresiding, (DataAware.Listener)new RedrawListener("<facilitator>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowNotetaker", (Object)this.chkNoteTaker, (DataAware.Listener)new RedrawListener("<notetaker>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowTimekeeper", (Object)this.chkTimekeeper, (DataAware.Listener)new RedrawListener("<timekeeper>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowAttendees", (Object)this.chkAttendees, (DataAware.Listener)new RedrawListener("<attendees>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowObservers", (Object)this.chkObservers, (DataAware.Listener)new RedrawListener("<observers>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowResourcePersons", (Object)this.chkResourcePersons, (DataAware.Listener)new RedrawListener("<resource-persons>"), (boolean)true).updateUI();
        UnoDataAware.attachEditControl((Object)((Object)this.agenda), (String)"cp_TemplateName", (Object)this.txtTemplateName, null, (boolean)true).updateUI();
        RadioDataAware.attachRadioButtons((Object)((Object)this.agenda), (String)"cp_ProceedMethod", (Object[])new Object[]{this.optCreateAgenda, this.optMakeChanges}, null, (boolean)true).updateUI();
        this.listPageDesign.addItemListener(new XItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AgendaWizardDialogImpl.this.pageDesignChanged(itemEvent);
            }

            public void disposing(EventObject eventObject) {
            }
        });
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.NamingService";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect((String)string);
            AgendaWizardDialogImpl agendaWizardDialogImpl = new AgendaWizardDialogImpl(xMultiServiceFactory);
            agendaWizardDialogImpl.startWizard();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean initializeTemplates() {
        try {
            String string = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Template", (String)"share", (String)"/wizard");
            String string2 = FileAccess.combinePaths((XMultiServiceFactory)this.xMSF, (String)string, (String)"/wizard/agenda");
            this.agendaTemplates = FileAccess.getFolderTitles((XMultiServiceFactory)this.xMSF, (String)"aw", (String)string2);
            return true;
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void pageDesignChanged(ItemEvent itemEvent) {
        int n = itemEvent.Selected;
        try {
            this.agendaTemplate.load(this.agendaTemplates[1][n], this.topicsControl.getTopicsData());
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (String)"ErrBox", (int)0x400000, (String)this.resources.resErrOpenTemplate);
            exception.printStackTrace();
        }
    }

    public void templateTitleChanged() {
        String string = (String)Helper.getUnoPropertyValue((Object)AgendaWizardDialogImpl.getModel((Object)this.txtTemplateName), (String)"Text");
        this.agendaTemplate.setTemplateTitle(string);
    }

    private FileAccess getFileAccess() {
        if (this.fileAccess1 == null) {
            try {
                this.fileAccess1 = new FileAccess(this.xMSF);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fileAccess1;
    }

    public void saveAs() {
        try {
            this.checkSavePath();
            SystemDialog systemDialog = SystemDialog.createStoreDialog((XMultiServiceFactory)this.xMSF);
            systemDialog.addFilterToDialog("ott", "writer8_template", true);
            String string = systemDialog.callStoreDialog(FileAccess.getParentDir((String)this.agenda.cp_TemplatePath), FileAccess.getFilename((String)this.agenda.cp_TemplatePath));
            if (string != null) {
                this.agenda.cp_TemplatePath = string;
                this.setFilename(string);
                this.filenameChanged = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setFilename(String string) {
        try {
            String string2 = this.getFileAccess().getPath(string, "");
            Helper.setUnoPropertyValue((Object)AgendaWizardDialogImpl.getModel((Object)this.myPathSelection.xSaveTextBox), (String)"Text", (Object)string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertRow() {
        this.topicsControl.insertRow();
    }

    public void removeRow() {
        this.topicsControl.removeRow();
    }

    public void rowUp() {
        this.topicsControl.rowUp();
    }

    public void rowDown() {
        this.topicsControl.rowDown();
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
        running = false;
    }

    public void finishWizard() {
        XTextDocument xTextDocument;
        PropertyValue[] propertyValueArray;
        boolean bl = false;
        try {
            int n;
            propertyValueArray = new FileAccess(this.xMSF);
            this.sPath = this.myPathSelection.getSelectedPath();
            if (this.sPath.equals("")) {
                this.myPathSelection.triggerPathPicker();
                this.sPath = this.myPathSelection.getSelectedPath();
            }
            this.sPath = propertyValueArray.getURL(this.sPath);
            if (!this.filenameChanged && propertyValueArray.exists(this.sPath, true) && (n = SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (XWindowPeer)this.xControl.getPeer(), (String)"MessBox", (int)-2130706432, (String)this.resources.resFileExists)) == 3) {
                return;
            }
            this.agendaTemplate.xTextDocument.lockControllers();
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)XTextDocument.class, (Object)this.agendaTemplate.document);
            bl = OfficeDocument.store((XMultiServiceFactory)this.xMSF, (XComponent)xTextDocument, (String)this.sPath, (String)"writer8_template", (boolean)false, (String)this.resources.resErrSaveTemplate);
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (XWindowPeer)this.xControl.getPeer(), (String)"ErrBox", (int)0x400000, (String)this.resources.resErrSaveTemplate);
        }
        if (bl) {
            Object object;
            try {
                this.topicsControl.saveTopics(this.agenda);
                propertyValueArray = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.Writer/Wizards/Agenda", (boolean)true);
                this.agenda.writeConfiguration(propertyValueArray, "cp_");
                Configuration.commit((Object)propertyValueArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.agendaTemplate.finish(this.topicsControl.getTopicsData());
            try {
                propertyValueArray = (XStorable)UnoRuntime.queryInterface((Class)XStorable.class, (Object)this.agendaTemplate.document);
                propertyValueArray.store();
            }
            catch (Exception exception) {
                SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (String)"ErrBox", (int)0x400000, (String)this.resources.resErrSaveTemplate);
                exception.printStackTrace();
            }
            this.agendaTemplate.xTextDocument.unlockControllers();
            propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "AsTemplate";
            propertyValueArray[0].Value = this.agenda.cp_ProceedMethod == 1 ? Boolean.TRUE : Boolean.FALSE;
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "InteractionHandler";
            try {
                object = (XInteractionHandler)UnoRuntime.queryInterface((Class)XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.comp.uui.UUIInteractionHandler"));
                propertyValueArray[1].Value = object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = OfficeDocument.load((XInterface)Desktop.getDesktop((XMultiServiceFactory)this.xMSF), (String)this.sPath, (String)"_default", (PropertyValue[])new PropertyValue[0]);
            xTextDocument = (XTextDocument)object;
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)XMultiServiceFactory.class, (Object)xTextDocument);
            ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
            try {
                viewHandler.setViewSetting("ZoomType", (Object)new Short(0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.agendaTemplate.xTextDocument.unlockControllers();
            return;
        }
        this.xDialog.endExecute();
        running = false;
    }

    private void closeDocument() {
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)XCloseable.class, (Object)this.agendaTemplate.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    private class RedrawListener
    implements DataAware.Listener {
        private String itemName;

        public RedrawListener(String string) {
            this.itemName = string;
        }

        public void eventPerformed(Object object) {
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.lockControllers();
            AgendaWizardDialogImpl.this.agendaTemplate.redraw(this.itemName);
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.unlockControllers();
        }
    }

    private class myPathSelectionListener
    implements XPathSelectionListener {
        private myPathSelectionListener() {
        }

        public void validatePath() {
            if (AgendaWizardDialogImpl.this.myPathSelection.usedPathPicker) {
                AgendaWizardDialogImpl.this.filenameChanged = true;
            }
            AgendaWizardDialogImpl.this.myPathSelection.usedPathPicker = false;
        }
    }
}

