/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.Component;
import org.openoffice.java.accessibility.Menu;
import org.openoffice.java.accessibility.ToggleButton;

class MenuItem
extends ToggleButton {
    public MenuItem(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleMenuItemListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleMenuItem();
    }

    protected class AccessibleMenuItem
    extends ToggleButton.AccessibleToggleButton {
        protected AccessibleMenuItem() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() instanceof Menu) {
                return ((Menu)this.getAccessibleParent()).indexOf(MenuItem.this);
            }
            return super.getAccessibleIndexInParent();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.remove(AccessibleState.SELECTABLE);
            if (accessibleStateSet.remove(AccessibleState.SELECTED)) {
                accessibleStateSet.add(AccessibleState.ARMED);
            }
            return accessibleStateSet;
        }
    }

    protected class AccessibleMenuItemListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleMenuItemListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            if (s == 23) {
                MenuItem.this.fireStatePropertyChange(AccessibleState.ARMED, bl);
            } else {
                super.setComponentState(s, bl);
            }
        }
    }
}

