/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.tools.debugger.ScriptItem;

class SourceInfo {
    private String sourceUrl;
    private String source;
    private int endLine;
    private boolean[] breakableLines;
    private static final byte BREAK_FLAG = 1;
    private static final byte OLD_BREAK_FLAG = 2;
    private byte[] breakpoints;

    static String getShortName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        String string2 = string;
        if (n >= 0 && n + 1 < string.length()) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    SourceInfo(String string, String string2) {
        this.sourceUrl = string;
        this.source = string2;
    }

    String getUrl() {
        return this.sourceUrl;
    }

    String getSource() {
        return this.source;
    }

    synchronized void setSource(String string) {
        if (!this.source.equals(string)) {
            this.source = string;
            this.endLine = 0;
            this.breakableLines = null;
            if (this.breakpoints != null) {
                for (int i = this.breakpoints.length - 1; i >= 0; --i) {
                    if (this.breakpoints[i] != 1) continue;
                    this.breakpoints[i] = 2;
                }
            }
        }
    }

    synchronized void updateLineInfo(ScriptItem scriptItem) {
        int n;
        int[] nArray = scriptItem.getScript().getLineNumbers();
        if (nArray.length == 0) {
            return;
        }
        int n2 = nArray[0];
        int n3 = n2 + 1;
        for (n = 1; n != nArray.length; ++n) {
            int n4 = nArray[n];
            if (n4 < n2) {
                n2 = n4;
                continue;
            }
            if (n4 < n3) continue;
            n3 = n4 + 1;
        }
        scriptItem.setFirstLine(n2);
        if (this.endLine < n3) {
            this.endLine = n3;
        }
        if (this.breakableLines == null) {
            n = 20;
            if (n < this.endLine) {
                n = this.endLine;
            }
            this.breakableLines = new boolean[n];
        } else if (this.breakableLines.length < this.endLine) {
            n = this.breakableLines.length * 2;
            if (n < this.endLine) {
                n = this.endLine;
            }
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.breakableLines, 0, blArray, 0, this.breakableLines.length);
            this.breakableLines = blArray;
        }
        n = this.breakpoints == null ? 0 : this.breakpoints.length;
        for (int i = 0; i != nArray.length; ++i) {
            int n5 = nArray[i];
            this.breakableLines[n5] = true;
            if (n5 >= n || this.breakpoints[n5] != 2) continue;
            this.breakpoints[n5] = 1;
        }
    }

    boolean breakableLine(int n) {
        boolean[] blArray = this.breakableLines;
        if (blArray != null && n < blArray.length) {
            return blArray[n];
        }
        return false;
    }

    boolean hasBreakpoint(int n) {
        byte[] byArray = this.breakpoints;
        if (byArray != null && n < byArray.length) {
            return byArray[n] == 1;
        }
        return false;
    }

    synchronized boolean placeBreakpoint(int n) {
        if (this.breakableLine(n)) {
            if (this.breakpoints == null) {
                this.breakpoints = new byte[this.endLine];
            } else if (n >= this.breakpoints.length) {
                byte[] byArray = new byte[this.endLine];
                System.arraycopy(this.breakpoints, 0, byArray, 0, this.breakpoints.length);
                this.breakpoints = byArray;
            }
            this.breakpoints[n] = 1;
            return true;
        }
        return false;
    }

    synchronized boolean removeBreakpoint(int n) {
        boolean bl = false;
        if (this.breakpoints != null && n < this.breakpoints.length) {
            bl = this.breakpoints[n] != 1;
            this.breakpoints[n] = 0;
        }
        return bl;
    }

    synchronized void removeAllBreakpoints() {
        this.breakpoints = null;
    }
}

