/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore.exporter;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.ecore.EcoreSchemaBuilder;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.ecore.exporter.XSDExporterPlugin;

public class XSDExporter
extends ModelExporter {
    protected MapBuilder mapBuilder;

    public String getID() {
        return "org.eclipse.xsd.ecore.exporter";
    }

    public void dispose() {
        this.mapBuilder = null;
        super.dispose();
    }

    protected String getDefaultArtifactLocation(EPackage ePackage) {
        return String.valueOf(this.getDefaultArtifactFileName(ePackage)) + ".xsd";
    }

    protected String doCheckEPackageArtifactLocation(String location, String packageName) {
        if (!location.endsWith(".xsd")) {
            return XSDExporterPlugin.INSTANCE.getString("_UI_InvalidArtifactFileNameExtension_message");
        }
        return super.doCheckEPackageArtifactLocation(location, packageName);
    }

    protected XSDSchema getSchema(EPackage ePackage) {
        if (this.mapBuilder == null) {
            this.mapBuilder = new EcoreSchemaBuilder(this.genModel.getExtendedMetaData()){

                protected String getQualifiedPackageName(EPackage ePackage) {
                    return ((ModelConverter)XSDExporter.this).genModel.findGenPackage(ePackage).getQualifiedPackageName();
                }
            };
        }
        return ((EcoreSchemaBuilder)this.mapBuilder).getSchema(ePackage);
    }

    protected Diagnostic doExport(Monitor monitor, ModelExporter.ExportData exportData) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Iterator i = exportData.genPackageToArtifactURI.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            GenPackage genPackage = (GenPackage)entry.getKey();
            EPackage ePackage = genPackage.getEcorePackage();
            URI schemaLocationURI = (URI)entry.getValue();
            XSDSchema xsdSchema = this.getSchema(ePackage);
            Iterator j = xsdSchema.getContents().iterator();
            while (j.hasNext()) {
                Object content = j.next();
                if (content instanceof XSDImport) {
                    XSDImport xsdImport = (XSDImport)content;
                    EPackage referencedEPackage = this.genModel.getExtendedMetaData().getPackage(xsdImport.getNamespace());
                    GenPackage referencedGenPackage = this.genModel.findGenPackage(referencedEPackage);
                    URI artifactURI = this.getReferencedGenPackageArtifactURI(exportData, referencedGenPackage);
                    xsdImport.setSchemaLocation(this.computeSchemaLocation((XSDSchemaDirective)xsdImport, artifactURI));
                    continue;
                }
                if (!(content instanceof XSDAnnotation)) break;
            }
            Resource resource = resourceSet.createResource(schemaLocationURI);
            resource.getContents().add((Object)xsdSchema);
            resource.save(null);
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected URI getReferencedGenPackageArtifactURI(ModelExporter.ExportData exportData, GenPackage genPackage) {
        URI artifactURI = (URI)exportData.referencedGenPackagesToArtifactURI.get(genPackage);
        if (artifactURI == null && (artifactURI = (URI)exportData.genPackageToArtifactURI.get(genPackage)) == null) {
            Iterator i = exportData.referencedGenPackagesToArtifactURI.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                GenPackage referencedGenPackage = (GenPackage)entry.getKey();
                if (!genPackage.getNSURI().equals(referencedGenPackage.getNSURI()) || !genPackage.getEcorePackage().getName().equals(referencedGenPackage.getEcorePackage().getName())) continue;
                artifactURI = (URI)entry.getValue();
            }
        }
        return artifactURI;
    }

    protected String computeSchemaLocation(XSDSchemaDirective xsdSchemaDirective, URI artifactURI) {
        if (artifactURI != null) {
            return artifactURI.toString();
        }
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(xsdSchemaDirective.getSchemaLocation())) {
            return "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.xsd";
        }
        return xsdSchemaDirective.getSchemaLocation();
    }
}

