from Products.PortalTransforms.interfaces import itransform

try:
    # use Zope's rest writer by default
    from reStructuredText import HTML, render
    USE_ZOPE=1
except ImportError:
    from Products.PortalTransforms.libtransforms.zope27rest import HTML, render
    USE_ZOPE=0

import sys
if sys.version_info < (2,2):
    # XXX: fix the types module to make it docutils working with py2.1
    import types
    types.StringTypes = (types.UnicodeType, types.StringType)

def reSTwriter(orig, input_encoding, output_encoding,
               language, warnings=None,
               initial_header_level=2,
               report_level=2):
    """uses either the zope implementation of reST or the
    PortalTransforms html4zope
    """
    settings = {'documentclass': '',
                'traceback': 1,
               }

    warnings = None
    return HTML(orig, input_encoding=input_encoding,
                output_encoding=output_encoding,
                language_code=language,
                initial_header_level=initial_header_level,
                report_level=report_level,
                warnings=warnings,
                settings=settings)

class rest:
    __implements__ = itransform

    __name__ = "rest_to_html"
    inputs  = ("text/x-rst", "text/restructured",)
    output = "text/html"

    def __init__(self, name=None, **kwargs):
        if name:
            self.__name__ = name

        self.config = {
            'inputs': self.inputs,
            'output': self.output,
            'report_level': 2,
            'initial_header_level': 2,
            }

        self.config_metadata = {
            'inputs' :
            ('list', 'Inputs', 'Input(s) MIME type. Change with care.'),
            'initial_header_level' :
            ('int', 'Initial Header Level',
             'Level of first header tag. Setting it to "2" will make '
             'the first header be "<h2>".'),
            'report_level' :
            ('int', 'Report Level',
             'Level of error reporting. Set to "1" will display all '
             'messages. Setting it to "5" will display no messages.'),
            }

        self.config.update(kwargs)


    def name(self):
        return self.__name__

    def convert(self, orig, data, **kwargs):
        # do the format
        encoding        = kwargs.get('encoding', 'utf-8')
        input_encoding  = kwargs.get('input_encoding', encoding)
        output_encoding = kwargs.get('output_encoding', encoding)
        language        = kwargs.get('language', 'en')

        initial_header_level = int(self.config.get('initial_header_level', 2))
        report_level = int(self.config.get('report_level', 2))

        html = reSTwriter(orig, input_encoding, output_encoding, language,
                          initial_header_level=initial_header_level,
                          report_level=report_level)

        html = html.replace(' class="document"', '', 1)
        data.setData(html)
        return data

def register():
    return rest()
