/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Library;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

class Function {
    private String sFunction;
    private Method mMethod;
    private Class cReturnClass;
    private Class[] aArgClasses;
    private int iReturnType;
    private int iArgCount;
    private int iSqlArgCount;
    private int iSqlArgStart;
    private int[] iArgType;
    private boolean[] bArgNullable;
    Expression[] eArg;
    private boolean bConnection;
    private static HashMap methodCache = new HashMap();
    private int fID;
    String name;
    boolean isSimple;
    boolean hasAggregate;

    Function(String string, String string2, boolean bl) throws HsqlException {
        Object object;
        Object object2;
        this.name = string;
        this.isSimple = bl;
        this.sFunction = string2;
        this.fID = Library.functionID(string2);
        int n = string2.lastIndexOf(46);
        Trace.check(n != -1, 11, string2);
        String string3 = string2.substring(0, n);
        this.mMethod = (Method)methodCache.get(string2);
        if (this.mMethod == null) {
            object2 = string2.substring(n + 1);
            object = null;
            try {
                object = Class.forName(string3);
            }
            catch (Exception exception) {
                throw Trace.error(42, 115, new Object[]{string3, exception});
            }
            Method[] methodArray = ((Class)object).getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                Method method = methodArray[n];
                if (!method.getName().equals(object2) || !Modifier.isStatic(method.getModifiers())) continue;
                this.mMethod = method;
                break;
            }
            Trace.check(this.mMethod != null, 13, object2);
            methodCache.put(string2, this.mMethod);
        }
        this.cReturnClass = this.mMethod.getReturnType();
        this.iReturnType = this.cReturnClass.equals(Result.class) ? 1111 : Types.getParameterTypeNr(this.cReturnClass);
        this.aArgClasses = this.mMethod.getParameterTypes();
        this.iArgCount = this.aArgClasses.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        for (n = 0; n < this.aArgClasses.length; ++n) {
            object2 = this.aArgClasses[n];
            object = ((Class)object2).getName();
            if (n == 0 && object2.equals(Connection.class)) {
                this.bConnection = true;
                continue;
            }
            this.iArgType[n] = Types.getParameterTypeNr((Class)object2);
            this.bArgNullable[n] = !((Class)object2).isPrimitive();
        }
        this.iSqlArgCount = this.iArgCount;
        if (this.bConnection) {
            --this.iSqlArgCount;
            this.iSqlArgStart = 1;
        } else {
            this.iSqlArgStart = 0;
        }
        this.eArg = new Expression[this.iArgCount];
    }

    Object getValue(Session session) throws HsqlException {
        switch (this.fID) {
            case 10: {
                return session.getCurrentTime();
            }
            case 9: {
                return session.getCurrentDate();
            }
            case 11: {
                return session.getDatabase().getPath();
            }
            case 19: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                return session.getLastIdentity();
            }
            case 30: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                return session.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 31: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return session.getCurrentTimestamp();
            }
            case 64: {
                return session.getUsername();
            }
        }
        Object[] objectArray = this.getArguments(session);
        if (objectArray == null) {
            return null;
        }
        return this.getValue(session, objectArray);
    }

    Object getValue(Session session, Object[] objectArray) throws HsqlException {
        if (this.bConnection) {
            objectArray[0] = session.getInternalConnection();
        }
        try {
            Object object = this.fID >= 0 ? Library.invoke(this.fID, objectArray) : this.mMethod.invoke(null, objectArray);
            return Column.convertObject(object, this.iReturnType);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = this.sFunction + " : " + throwable.toString();
            throw Trace.error(198, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Trace.error(198);
        }
    }

    private Object[] getArguments(Session session) throws HsqlException {
        Object[] objectArray = new Object[this.iArgCount];
        for (int i = this.bConnection ? 1 : 0; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            Object object = null;
            if (expression != null) {
                object = expression.getValue(session, this.iArgType[i]);
            }
            if (object == null && !this.bArgNullable[i]) {
                return null;
            }
            if (object instanceof JavaObject) {
                object = ((JavaObject)object).getObject();
            } else if (object instanceof Binary) {
                object = ((Binary)object).getBytes();
            }
            objectArray[i] = object;
        }
        return objectArray;
    }

    private Object[] getNotNull(Object[] objectArray) throws HsqlException {
        int n;
        int n2 = n = this.bConnection ? 1 : 0;
        while (n < this.iArgCount) {
            Object object = objectArray[n];
            if (object == null && !this.bArgNullable[n]) {
                return null;
            }
            ++n;
        }
        return objectArray;
    }

    void collectInGroupByExpressions(HsqlArrayList hsqlArrayList) {
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (expression == null) continue;
            expression.collectInGroupByExpressions(hsqlArrayList);
        }
    }

    Object getAggregatedValue(Session session, Object object) throws HsqlException {
        Object[] objectArray = (Object[])object;
        if (objectArray == null) {
            objectArray = new Object[this.iArgCount];
        }
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (this.eArg[i] == null) continue;
            objectArray[i] = this.eArg[i].isAggregate() ? Column.convertObject(expression.getAggregatedValue(session, objectArray[i]), this.iArgType[i]) : expression.getValue(session, this.iArgType[i]);
        }
        if ((objectArray = this.getNotNull(objectArray)) == null) {
            return null;
        }
        return this.getValue(session, objectArray);
    }

    Object updateAggregatingValue(Session session, Object object) throws HsqlException {
        Object[] objectArray = (Object[])object;
        if (objectArray == null) {
            objectArray = new Object[this.iArgCount];
        }
        for (int i = 0; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (this.eArg[i] == null) continue;
            objectArray[i] = expression.updateAggregatingValue(session, objectArray[i]);
        }
        return objectArray;
    }

    int getArgCount() {
        return this.iSqlArgCount;
    }

    void replaceAliases(Expression[] expressionArray, int n) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (expression == null) continue;
            if (expression.exprType == 2) {
                this.eArg[i] = expression.getExpressionForAlias(expressionArray, n);
                continue;
            }
            expression.replaceAliases(expressionArray, n);
        }
    }

    void checkTables(HsqlArrayList hsqlArrayList) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (expression == null) continue;
            expression.checkTables(hsqlArrayList);
        }
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (expression == null) continue;
            expression.resolveTables(tableFilter);
        }
    }

    void resolveType(Session session) throws HsqlException {
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            Expression expression = this.eArg[i];
            if (expression == null) continue;
            if (expression.isParam()) {
                expression.setDataType(this.iArgType[i]);
                expression.nullability = this.getArgNullability(i);
                expression.valueClassName = this.getArgClass(i).getName();
                continue;
            }
            expression.resolveTypes(session);
        }
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        boolean bl2 = true;
        for (int i = this.iSqlArgStart; i < this.iArgCount; ++i) {
            if (this.eArg[i] == null) continue;
            bl2 = bl2 && this.eArg[i].checkResolved(bl);
        }
        return bl2;
    }

    int getArgType(int n) {
        return this.iArgType[n];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int n, Expression expression) {
        if (this.bConnection) {
            ++n;
        }
        this.eArg[n] = expression;
        this.hasAggregate = this.hasAggregate || expression != null && expression.isAggregate();
    }

    String getDLL() throws HsqlException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.name;
        if (this.isSimple) {
            return this.name;
        }
        if ("TRIM".equals(this.name)) {
            stringBuffer.append(this.name).append('(');
            boolean bl = this.eArg[2].testCondition(null);
            boolean bl2 = this.eArg[3].testCondition(null);
            if (bl && bl2) {
                stringBuffer.append("BOTH");
            } else {
                stringBuffer.append(bl ? "LEADING" : "TRAILING");
            }
            stringBuffer.append(' ');
            String string2 = (String)this.eArg[1].getValue(null);
            stringBuffer.append(Column.createSQLString(string2)).append(' ');
            stringBuffer.append("FROM").append(' ');
            stringBuffer.append(this.eArg[0].getDDL()).append(')');
            return stringBuffer.toString();
        }
        if (this.sFunction.equals(this.name)) {
            string = StringConverter.toQuotedString(this.name, '\"', true);
        }
        stringBuffer.append(string).append('(');
        for (int i = this.iSqlArgStart; i < this.eArg.length; ++i) {
            stringBuffer.append(this.eArg[i].getDDL());
            if (i >= this.eArg.length - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String describe(Session session) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("=[\n");
        stringBuffer.append(this.sFunction).append("(");
        for (int i = this.iSqlArgStart; i < this.eArg.length; ++i) {
            stringBuffer.append("[").append(this.eArg[i].describe(session)).append("]");
        }
        stringBuffer.append(") returns ").append(Types.getTypeString(this.getReturnType()));
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    Class getReturnClass() {
        return this.cReturnClass;
    }

    Class getArgClass(int n) {
        return this.aArgClasses[n];
    }

    int getArgNullability(int n) {
        return this.bArgNullable[n] ? 1 : 0;
    }

    Method getMethod() {
        return this.mMethod;
    }
}

