/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web.data;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.DateTime;
import com.sun.star.wizards.common.ConfigGroup;
import com.sun.star.wizards.common.ConfigSet;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.web.data.CGExporter;
import com.sun.star.wizards.web.data.CGFilter;
import com.sun.star.wizards.web.data.CGIconSet;
import com.sun.star.wizards.web.data.CGImage;
import com.sun.star.wizards.web.data.CGLayout;
import com.sun.star.wizards.web.data.CGSession;
import com.sun.star.wizards.web.data.CGSessionName;
import com.sun.star.wizards.web.data.CGStyle;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class CGSettings
extends ConfigGroup {
    public String soTemplateDir;
    public String soGalleryDir;
    public String workPath = null;
    public String cp_WorkDir;
    public ConfigSet cp_Exporters = new ConfigSet(CGExporter.class);
    public ConfigSet cp_Layouts = new ConfigSet(CGLayout.class);
    public ConfigSet cp_Styles = new ConfigSet(CGStyle.class);
    public ConfigSet cp_IconSets = new ConfigSet(CGIconSet.class);
    public ConfigSet cp_BackgroundImages = new ConfigSet(CGImage.class);
    public ConfigSet cp_SavedSessions = new ConfigSet(CGSessionName.class);
    public ConfigSet cp_Filters = new ConfigSet(CGFilter.class);
    public ConfigSet savedSessions = new ConfigSet(CGSessionName.class);
    public CGSession cp_DefaultSession = new CGSession();
    public String cp_LastSavedSession;
    private Map exportersMap = new Hashtable();
    private XMultiServiceFactory xmsf;
    String[] resources;
    public Formatter formatter;
    public static final int RESOURCE_PAGES_TEMPLATE = 0;
    public static final int RESOURCE_SLIDES_TEMPLATE = 1;
    public static final int RESOURCE_CREATED_TEMPLATE = 2;
    public static final int RESOURCE_UPDATED_TEMPLATE = 3;
    public static final int RESOURCE_SIZE_TEMPLATE = 4;
    private static final CGExporter[] EMPTY_ARRAY_1 = new CGExporter[0];
    FileAccess fileAccess;

    public CGSettings(XMultiServiceFactory xMultiServiceFactory, String[] stringArray, Object object) {
        this.xmsf = xMultiServiceFactory;
        try {
            this.soTemplateDir = FileAccess.getOfficePath((XMultiServiceFactory)this.xmsf, (String)"Config", (String)"", (String)"");
            this.soGalleryDir = FileAccess.getOfficePath((XMultiServiceFactory)this.xmsf, (String)"Gallery", (String)"share", (String)"");
            this.root = this;
            this.formatter = new Formatter(this.xmsf, object);
            this.resources = stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CGExporter[] getExporters(String string) {
        CGExporter[] cGExporterArray = (CGExporter[])this.exportersMap.get(string);
        if (cGExporterArray == null) {
            cGExporterArray = this.createExporters(string);
            this.exportersMap.put(string, cGExporterArray);
        }
        return cGExporterArray;
    }

    private CGExporter[] createExporters(String string) {
        Object[] objectArray = this.cp_Exporters.items();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((CGExporter)((Object)objectArray[i])).supports(string)) continue;
            try {
                vector.add(objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector.toArray(EMPTY_ARRAY_1);
    }

    public void configure(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        this.workPath = FileAccess.connectURLs((String)this.soTemplateDir, (String)this.cp_WorkDir);
        this.calcExportersTargetTypeNames(xMultiServiceFactory);
    }

    private void calcExportersTargetTypeNames(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.document.TypeDetection");
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)XNameAccess.class, (Object)object);
        for (int i = 0; i < this.cp_Exporters.getSize(); ++i) {
            this.calcExporterTargetTypeName(xNameAccess, (CGExporter)((Object)this.cp_Exporters.getElementAt(i)));
        }
    }

    private void calcExporterTargetTypeName(XNameAccess xNameAccess, CGExporter cGExporter) throws NoSuchElementException, WrappedTargetException {
        if (!cGExporter.cp_TargetType.equals("")) {
            cGExporter.targetTypeName = (String)Properties.getPropertyValue((PropertyValue[])((PropertyValue[])xNameAccess.getByName(cGExporter.cp_TargetType)), (String)"UIName");
        }
    }

    FileAccess getFileAccess() throws Exception {
        return this.getFileAccess(this.xmsf);
    }

    FileAccess getFileAccess(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        if (this.fileAccess == null) {
            this.fileAccess = new FileAccess(xMultiServiceFactory);
        }
        return this.fileAccess;
    }

    public class Formatter {
        private long docNullTime;
        private int dateFormat;
        private int numberFormat;
        private Helper.DateUtils dateUtils;

        public Formatter(XMultiServiceFactory xMultiServiceFactory, Object object) throws Exception {
            this.dateUtils = new Helper.DateUtils(xMultiServiceFactory, object);
            this.dateFormat = this.dateUtils.getFormat((short)23);
            this.numberFormat = this.dateUtils.getFormat((short)4);
        }

        public String formatCreated(DateTime dateTime) {
            String string = this.dateUtils.format(this.dateFormat, dateTime);
            return JavaTools.replaceSubString((String)CGSettings.this.resources[2], (String)string, (String)"%DATE");
        }

        public String formatUpdated(DateTime dateTime) {
            String string = this.dateUtils.format(this.dateFormat, dateTime);
            return JavaTools.replaceSubString((String)CGSettings.this.resources[3], (String)string, (String)"%DATE");
        }

        public String formatFileSize(int n) {
            float f = (float)n / 1024.0f;
            String string = this.dateUtils.getFormatter().convertNumberToString(this.numberFormat, (double)f);
            return JavaTools.replaceSubString((String)CGSettings.this.resources[4], (String)string, (String)"%NUMBER");
        }
    }
}

