/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.Runner;

public class Global
extends ImporterTopLevel {
    static final String privateName = "org.mozilla.javascript.tools.shell.Global private";
    NativeArray history;
    public InputStream inStream;
    public PrintStream outStream;
    public PrintStream errStream;

    public Global(Context context) {
        super(context);
        String[] stringArray = new String[]{"print", "quit", "version", "load", "help", "loadClass", "defineClass", "spawn", "sync", "serialize", "deserialize", "runCommand"};
        try {
            this.defineFunctionProperties(stringArray, Global.class, 2);
        }
        catch (PropertyException propertyException) {
            throw new Error();
        }
        this.defineProperty(privateName, this, 2);
        Environment.defineClass(this);
        Environment environment = new Environment(this);
        this.defineProperty("environment", environment, 2);
        this.history = (NativeArray)context.newArray((Scriptable)this, 0);
        this.defineProperty("history", this.history, 2);
    }

    public static void help(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(scriptable).getOut();
        printStream.println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static Object print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(scriptable).getOut();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                printStream.print(" ");
            }
            String string = Context.toString(objectArray[i]);
            printStream.print(string);
        }
        printStream.println();
        return Context.getUndefinedValue();
    }

    public static void quit(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        System.exit(objectArray.length > 0 ? (int)Context.toNumber(objectArray[0]) : 0);
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            double d2 = Context.toNumber(objectArray[0]);
            context.setLanguageVersion((int)d2);
        }
        return d;
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        for (int i = 0; i < objectArray.length; ++i) {
            Main.processFile(context, scriptable, Context.toString(objectArray[i]));
        }
    }

    public static void defineClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Class clazz = Global.getClass(objectArray);
        ScriptableObject.defineClass(scriptable, clazz);
    }

    public static void loadClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, JavaScriptException {
        Class clazz;
        if (!Script.class.isAssignableFrom(clazz = Global.getClass(objectArray))) {
            throw Global.reportRuntimeError("msg.must.implement.Script");
        }
        Script script = (Script)clazz.newInstance();
        script.exec(context, scriptable);
    }

    private static Class getClass(Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (objectArray.length == 0) {
            throw Global.reportRuntimeError("msg.expected.string.arg");
        }
        String string = Context.toString(objectArray[0]);
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Global.reportRuntimeError("msg.class.not.found", string);
        }
    }

    public static void serialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length < 2) {
            throw Context.reportRuntimeError("Expected an object to serialize and a filename to write the serialization to");
        }
        Object object = objectArray[0];
        String string = Context.toString(objectArray[1]);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ScriptableOutputStream scriptableOutputStream = new ScriptableOutputStream(fileOutputStream, scriptable2);
        scriptableOutputStream.writeObject(object);
        scriptableOutputStream.close();
    }

    public static Object deserialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException, ClassNotFoundException {
        if (objectArray.length < 1) {
            throw Context.reportRuntimeError("Expected a filename to read the serialization from");
        }
        String string = Context.toString(objectArray[0]);
        FileInputStream fileInputStream = new FileInputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ScriptableInputStream scriptableInputStream = new ScriptableInputStream(fileInputStream, scriptable2);
        Object object = scriptableInputStream.readObject();
        scriptableInputStream.close();
        return Context.toObject(object, scriptable2);
    }

    public static Object spawn(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Runner runner;
        Object object;
        Scriptable scriptable2 = function.getParentScope();
        if (objectArray.length != 0 && objectArray[0] instanceof Function) {
            object = null;
            if (objectArray.length > 1 && objectArray[1] instanceof Scriptable) {
                object = context.getElements((Scriptable)objectArray[1]);
            }
            if (object == null) {
                object = ScriptRuntime.emptyArgs;
            }
            runner = new Runner(scriptable2, (Function)objectArray[0], (Object[])object);
        } else if (objectArray.length != 0 && objectArray[0] instanceof Script) {
            runner = new Runner(scriptable2, (Script)objectArray[0]);
        } else {
            throw Global.reportRuntimeError("msg.spawn.args");
        }
        object = new Thread(runner);
        ((Thread)object).start();
        return object;
    }

    public static Object sync(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length == 1 && objectArray[0] instanceof Function) {
            return new Synchronizer((Function)objectArray[0]);
        }
        throw Global.reportRuntimeError("msg.sync.args");
    }

    public static Object runCommand(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        int n;
        Object object;
        Object object2;
        int n2 = objectArray.length;
        if (n2 == 0 || n2 == 1 && objectArray[0] instanceof Scriptable) {
            throw Global.reportRuntimeError("msg.runCommand.bad.args");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        Object object3 = null;
        Object object4 = null;
        String[] stringArray = null;
        Scriptable scriptable2 = null;
        Object[] objectArray2 = null;
        if (objectArray[n2 - 1] instanceof Scriptable) {
            Object object5;
            scriptable2 = (Scriptable)objectArray[n2 - 1];
            --n2;
            object2 = ScriptableObject.getProperty(scriptable2, "env");
            if (object2 != Scriptable.NOT_FOUND) {
                if (object2 == null) {
                    stringArray = new String[]{};
                } else {
                    if (!(object2 instanceof Scriptable)) {
                        throw Global.reportRuntimeError("msg.runCommand.bad.env");
                    }
                    object = (Scriptable)object2;
                    object5 = ScriptableObject.getPropertyIds((Scriptable)object);
                    stringArray = new String[((Object[])object5).length];
                    for (int i = 0; i != ((Object[])object5).length; ++i) {
                        Object object6;
                        String string;
                        Object object7 = object5[i];
                        if (object7 instanceof String) {
                            string = (String)object7;
                            object6 = ScriptableObject.getProperty((Scriptable)object, string);
                        } else {
                            int n3 = ((Number)object7).intValue();
                            string = Integer.toString(n3);
                            object6 = ScriptableObject.getProperty((Scriptable)object, n3);
                        }
                        if (object6 == ScriptableObject.NOT_FOUND) {
                            object6 = Undefined.instance;
                        }
                        stringArray[i] = string + '=' + ScriptRuntime.toString(object6);
                    }
                }
            }
            if ((object = ScriptableObject.getProperty(scriptable2, "input")) != Scriptable.NOT_FOUND) {
                inputStream = Global.toInputStream(object);
            }
            if ((object3 = ScriptableObject.getProperty(scriptable2, "output")) != Scriptable.NOT_FOUND && (outputStream = Global.toOutputStream(object3)) == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = byteArrayOutputStream;
            }
            if ((object4 = ScriptableObject.getProperty(scriptable2, "err")) != Scriptable.NOT_FOUND && (outputStream2 = Global.toOutputStream(object4)) == null) {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                outputStream2 = byteArrayOutputStream2;
            }
            if ((object5 = ScriptableObject.getProperty(scriptable2, "args")) != Scriptable.NOT_FOUND) {
                Scriptable scriptable3 = Context.toObject(object5, Global.getTopLevelScope(scriptable));
                objectArray2 = context.getElements(scriptable3);
            }
        }
        object2 = Global.getInstance(scriptable);
        if (outputStream == null) {
            PrintStream printStream = outputStream = object2 != null ? ((Global)object2).getOut() : System.out;
        }
        if (outputStream2 == null) {
            outputStream2 = object2 != null ? ((Global)object2).getErr() : System.err;
        }
        object = new String[objectArray2 == null ? n2 : n2 + objectArray2.length];
        for (n = 0; n != n2; ++n) {
            object[n] = ScriptRuntime.toString(objectArray[n]);
        }
        if (objectArray2 != null) {
            for (n = 0; n != objectArray2.length; ++n) {
                object[n2 + n] = ScriptRuntime.toString(objectArray2[n]);
            }
        }
        n = Global.runProcess(object, stringArray, inputStream, outputStream, outputStream2);
        if (byteArrayOutputStream != null) {
            String string = ScriptRuntime.toString(object3) + byteArrayOutputStream.toString();
            ScriptableObject.putProperty(scriptable2, "output", (Object)string);
        }
        if (byteArrayOutputStream2 != null) {
            String string = ScriptRuntime.toString(object4) + byteArrayOutputStream2.toString();
            ScriptableObject.putProperty(scriptable2, "err", (Object)string);
        }
        return new Integer(n);
    }

    public InputStream getIn() {
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream printStream) {
        this.outStream = printStream;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream printStream) {
        this.errStream = printStream;
    }

    public static Global getInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty(scriptable, privateName);
        if (object instanceof Global) {
            return (Global)object;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static int runProcess(String[] var0, String[] var1_1, InputStream var2_2, OutputStream var3_3, OutputStream var4_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static void pipe(boolean var0, InputStream var1_1, OutputStream var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream toInputStream(Object object) throws IOException {
        InputStream inputStream = null;
        String string = null;
        if (object instanceof Wrapper) {
            Object object2 = ((Wrapper)object).unwrap();
            if (object2 instanceof InputStream) {
                inputStream = (InputStream)object2;
            } else if (object2 instanceof byte[]) {
                inputStream = new ByteArrayInputStream((byte[])object2);
            } else if (object2 instanceof Reader) {
                string = Global.readerToString((Reader)object2);
            } else if (object2 instanceof char[]) {
                string = new String((char[])object2);
            }
        }
        if (inputStream == null) {
            if (string == null) {
                string = ScriptRuntime.toString(object);
            }
            inputStream = new ByteArrayInputStream(string.getBytes());
        }
        return inputStream;
    }

    private static OutputStream toOutputStream(Object object) {
        Object object2;
        OutputStream outputStream = null;
        if (object instanceof Wrapper && (object2 = ((Wrapper)object).unwrap()) instanceof OutputStream) {
            outputStream = (OutputStream)object2;
        }
        return outputStream;
    }

    private static String readerToString(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        int n2 = 0;
        while ((n = reader.read(cArray, n2, cArray.length - n2)) >= 0) {
            if ((n2 += n) != cArray.length) continue;
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            cArray = cArray2;
        }
        return new String(cArray, 0, n2);
    }

    static RuntimeException reportRuntimeError(String string) {
        String string2 = ToolErrorReporter.getMessage(string);
        return Context.reportRuntimeError(string2);
    }

    static RuntimeException reportRuntimeError(String string, String string2) {
        String string3 = ToolErrorReporter.getMessage(string, string2);
        return Context.reportRuntimeError(string3);
    }
}

