/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _DIALOG_H
#define _DIALOG_H

#include "widget.h"

namespace uta {

/**Dialog.
   Either modal or nonmodal.
   At creation Dialog is hidden. Call exec() to popup the dialog.
   If the dialog is modal, exec() will return when the dialog closes. 
   When being nonmodal exec() returns at once with Dialog::OK.                 
   Calling either SLOT accept or SLOT reject will popdown 
   this dialog; this means the dialog is hidden. After that the method exec()
   may be called again to popup the dialog again.
   Prior to this the SIGNALs accepted
   or rejected and finally the SIGNAL done is emitted.
   done(0) is called for reject and done(1) is called for accept.
*/
class Dialog : public Widget
{

 public:
  ///
  enum {OK=1, CANCEL=0};
  ///
  Dialog(int x, int y, int w, int h, bool modal = false);
  ///
  virtual ~Dialog();

  ///
  void accept();
  ///
  void reject();

  ///
  SigC::Signal0<void> accepted;
  ///
  SigC::Signal0<void> rejected;
  ///
  SigC::Signal1<void, int> done;

  ///
  int exec();

 protected:
  ///
  bool modal_;
  ///
  int result_;
  ///
  bool open_;

};


}

#endif // !_DIALOG
