/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.services;

import org.eclipse.jface.window.Window;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.dialogs.ConnectedServerDialog;


/**
 * @author ljulien
 */
public class ConnectedServerDialogService implements IConnectedServerDialog
{
    private IConnectionNode[] connection;

    public int open()
    {
		ConnectedServerDialog dialog = new ConnectedServerDialog();
		int result = dialog.open();
		if (result == Window.OK)
		{
		    this.connection = dialog.getSelectedServers();
		}
		return result;
    }

    public IConnectionNode getUserSelection()
    {
        return this.connection.length == 1? this.connection[0] : null;
    }
}
