/*
 *+------------------------------------------------------------------------+
 *| Licensed Materials - Property of IBM                                   |
 *| (C) Copyright IBM Corp. 2005.  All Rights Reserved.                    |
 *|                                                                        |
 *| US Government Users Restricted Rights - Use, duplication or disclosure |
 *| restricted by GSA ADP Schedule Contract with IBM Corp.                 |
 *+------------------------------------------------------------------------+
 */
package org.eclipse.wst.rdb.server.internal.ui.query.execute;

import java.sql.Connection;
import java.sql.Statement;


public interface ISQLExecutionProvider 
{
  /* Returns a boolean which indicates whether this provider can be used 
   * to execute the SQL string passed in. */
  public boolean isProviderFor(String sqlStatementStr);

  /* Executes the SQL statement passed in on teh connection 
   * passed in.  The string must be a complete statement.  This 
   * method must only be called after the isProviderFor() method 
   * has returned true. Returns the JDBC statement that was 
   * created to execute the SQL statement passed in.  */
  public Statement execute(Connection con, String sqlStatementStr) throws Exception;
}