/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection;

import java.util.Hashtable;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;


public class ConnectionFactoryRegistry {
	public static final ConnectionFactoryRegistry INSTANCE = new ConnectionFactoryRegistry(); 
	
	private Hashtable connectionFactories = new Hashtable();
	
	private ConnectionFactoryRegistry() {
		IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core", "connectionFactory"); //$NON-NLS-1$ //$NON-NLS-2$
		IExtension[] extensions = extensionPoint.getExtensions();
		for(int i=0; i<extensions.length; ++i) {
			IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
			for(int j = 0; j < configElements.length; ++j) {
				if(configElements[j].getName().equals("factory")) { //$NON-NLS-1$
					String driverClassName = configElements[j].getAttribute("driverClassName"); //$NON-NLS-1$

					try {
						ConnectionFactory driverLoader = (ConnectionFactory) configElements[j].createExecutableExtension("class"); //$NON-NLS-1$
						connectionFactories.put(driverClassName, driverLoader);
					}
					catch(CoreException e) {
					    IStatus status = new Status(IStatus.ERROR, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), IStatus.ERROR,
					            "The error was detected when creating the connection factory for " + driverClassName, e); //$NON-NLS-1$ //$NON-NLS-2$
						RDBCorePlugin.getDefault().getLog().log(status);
					}
				}
			}
		}
	}
	
	public ConnectionFactory getConnectionFactory(String driverClassName){
		ConnectionFactory factory = (ConnectionFactory) connectionFactories.get(driverClassName);
		if (factory == null){
			return new GenericConnectionFactory();		
		} else {
			return factory;
		}
	}
}
