/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings = 56;
    private boolean stop = false;
    private String url;
    private IServer server;
    private TomcatServerBehaviour behaviour;

    public PingThread(IServer server, String url, int maxPings, TomcatServerBehaviour behaviour) {
        this.server = server;
        this.url = url;
        this.maxPings = maxPings;
        this.behaviour = behaviour;
        Thread t = new Thread("Tomcat Ping Thread"){

            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings) {
                    try {
                        this.server.stop(false);
                    }
                    catch (Exception exception) {
                        Trace.trace(Trace.FINEST, "Ping: could not stop server");
                    }
                    this.stop = true;
                    break;
                }
                ++count;
                Trace.trace(Trace.FINEST, "Ping: pinging");
                URL pingUrl = new URL(this.url);
                URLConnection conn = pingUrl.openConnection();
                ((HttpURLConnection)conn).getResponseCode();
                if (!this.stop) {
                    Trace.trace(Trace.FINEST, "Ping: success");
                    Thread.sleep(200L);
                    this.behaviour.setServerStarted();
                }
                this.stop = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
                this.behaviour.setServerStarted();
                this.stop = true;
            }
            catch (Exception exception) {
                Trace.trace(Trace.FINEST, "Ping: failed");
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        Trace.trace(Trace.FINEST, "Ping: stopping");
        this.stop = true;
    }
}

