/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.viewers.NavigableTableViewer;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddEnumerationsCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.DeleteCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.SetXSDFacetValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.widgets.EnumerationsDialog;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class EnumerationsSection
extends AbstractSection {
    private EnumerationsTableViewer enumerationsTable;
    private Button addButton;
    private Button addManyButton;
    private Button deleteButton;

    public void widgetSelected(SelectionEvent e) {
        XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.input;
        if (e.widget == this.addButton) {
            EList enumList = st.getEnumerationFacets();
            StringBuffer newName = new StringBuffer("value1");
            int suffix = 1;
            Iterator i = enumList.iterator();
            while (i.hasNext()) {
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)i.next();
                String value = enumFacet.getLexicalValue();
                if (value == null || !value.equals(newName.toString())) continue;
                newName = new StringBuffer("value" + String.valueOf(++suffix));
            }
            AddEnumerationsCommand command = new AddEnumerationsCommand(Messages._UI_ACTION_ADD_ENUMERATION, (XSDSimpleTypeDefinition)this.input);
            command.setValue(newName.toString());
            this.getCommandStack().execute((Command)command);
            this.enumerationsTable.refresh();
            int newItemIndex = this.enumerationsTable.getTable().getItemCount() - 1;
            this.enumerationsTable.editElement(this.enumerationsTable.getElementAt(newItemIndex), 0);
        } else if (e.widget == this.addManyButton) {
            Display display = Display.getCurrent();
            display = display == null ? Display.getDefault() : display;
            Shell parentShell = display.getActiveShell();
            EnumerationsDialog dialog = new EnumerationsDialog(parentShell);
            dialog.setBlockOnOpen(true);
            int result = dialog.open();
            if (result == 0) {
                String text = dialog.getText();
                String delimiter = dialog.getDelimiter();
                StringTokenizer tokenizer = new StringTokenizer(text, delimiter);
                CompoundCommand compoundCommand = new CompoundCommand(Messages._UI_ACTION_ADD_ENUMERATIONS);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!dialog.isPreserveWhitespace()) {
                        token = token.trim();
                    }
                    AddEnumerationsCommand command = new AddEnumerationsCommand(Messages._UI_ACTION_ADD_ENUMERATIONS, (XSDSimpleTypeDefinition)this.input);
                    command.setValue(token);
                    compoundCommand.add((Command)command);
                }
                this.getCommandStack().execute((Command)compoundCommand);
            }
            this.enumerationsTable.refresh();
        } else if (e.widget == this.deleteButton) {
            StructuredSelection selection = (StructuredSelection)this.enumerationsTable.getSelection();
            if (selection != null) {
                Iterator i = selection.iterator();
                CompoundCommand compoundCommand = new CompoundCommand(Messages._UI_ACTION_DELETE_ENUMERATION);
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj == null || !(obj instanceof XSDEnumerationFacet)) continue;
                    XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)obj;
                    DeleteCommand deleteCommand = new DeleteCommand(Messages._UI_ACTION_DELETE_ENUMERATION, (XSDConcreteComponent)enumFacet);
                    compoundCommand.add((Command)deleteCommand);
                }
                this.getCommandStack().execute((Command)compoundCommand);
                this.enumerationsTable.refresh();
            }
        } else if (e.widget == this.enumerationsTable.getTable()) {
            StructuredSelection selection = (StructuredSelection)this.enumerationsTable.getSelection();
            if (selection.getFirstElement() != null) {
                this.deleteButton.setEnabled(true);
            } else {
                this.deleteButton.setEnabled(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void createContents(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.composite = factory.createFlatFormComposite(parent);
        this.enumerationsTable = new EnumerationsTableViewer(this.getWidgetFactory().createTable(this.composite, 65538));
        this.enumerationsTable.setInput(this.input);
        Table table = this.enumerationsTable.getTable();
        table.addSelectionListener((SelectionListener)this);
        this.addButton = this.getWidgetFactory().createButton(this.composite, XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_ADD_BUTTON_LABEL"), 8);
        this.addManyButton = this.getWidgetFactory().createButton(this.composite, String.valueOf(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_ADD_BUTTON_LABEL")) + "...", 8);
        this.deleteButton = this.getWidgetFactory().createButton(this.composite, XSDEditorPlugin.getXSDString("_UI_ACTION_DELETE_INCLUDE"), 8);
        FormData data2 = new FormData();
        data2.top = new FormAttachment(0, 0);
        data2.left = new FormAttachment(100, -100);
        data2.right = new FormAttachment(100, 0);
        this.addButton.setLayoutData((Object)data2);
        this.addButton.addSelectionListener((SelectionListener)this);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.addButton, 0, 16384);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.addButton, 0);
        this.addManyButton.setLayoutData((Object)data);
        this.addManyButton.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment((Control)this.addButton, 0, 16384);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.addManyButton, 0);
        this.deleteButton.setLayoutData((Object)data);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.addButton, 0);
        data.bottom = new FormAttachment(100, 0);
        data.width = 50;
        table.setLayoutData((Object)data);
        table.addListener(11, (Listener)this);
    }

    public void refresh() {
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)this.input;
        Iterator validFacets = st.getValidFacets().iterator();
        boolean isApplicable = false;
        while (validFacets.hasNext()) {
            String aValidFacet = (String)validFacets.next();
            if (!aValidFacet.equals("enumeration")) continue;
            isApplicable = true;
        }
        if (isApplicable) {
            this.addButton.setEnabled(true);
            this.addManyButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
            this.addManyButton.setEnabled(false);
        }
        this.enumerationsTable.setInput(this.input);
    }

    public void handleEvent(Event event) {
        Table table = this.enumerationsTable.getTable();
        if (event.type == 11 && event.widget == table) {
            TableColumn tableColumn = table.getColumn(0);
            tableColumn.setWidth(table.getSize().x);
        }
    }

    public void dispose() {
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    class EnumerationsTableContentProvider
    implements IStructuredContentProvider {
        EnumerationsTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = new ArrayList();
            if (inputElement instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)inputElement;
                return st.getEnumerationFacets().toArray();
            }
            return list.toArray();
        }

        public void dispose() {
        }
    }

    class EnumerationsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return XSDEditorPlugin.getXSDImage("icons/XSDSimpleEnum.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XSDEnumerationFacet) {
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)element;
                String value = enumFacet.getLexicalValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }
    }

    class EnumerationsTableViewer
    extends NavigableTableViewer
    implements ICellModifier {
        protected String[] columnProperties = new String[]{"enumeration"};
        protected CellEditor[] cellEditors;
        Table table;

        public EnumerationsTableViewer(Table table) {
            super(table);
            table = this.getTable();
            table.setLinesVisible(true);
            this.setContentProvider((IContentProvider)new EnumerationsTableContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new EnumerationsTableLabelProvider());
            this.setColumnProperties(this.columnProperties);
            this.setCellModifier(this);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setText(this.columnProperties[0]);
            column.setAlignment(16384);
            column.setResizable(true);
            this.cellEditors = new CellEditor[1];
            TableLayout layout = new TableLayout();
            ColumnWeightData data = new ColumnWeightData(100);
            layout.addColumnData((ColumnLayoutData)data);
            this.cellEditors[0] = new TextCellEditor((Composite)table);
            this.getTable().setLayout((Layout)layout);
            this.setCellEditors(this.cellEditors);
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem && value != null) {
                TableItem item = (TableItem)element;
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)item.getData();
                SetXSDFacetValueCommand command = new SetXSDFacetValueCommand(Messages._UI_ACTION_SET_ENUMERATION_VALUE, (XSDFacet)enumFacet);
                command.setValue((String)value);
                EnumerationsSection.this.getCommandStack().execute((Command)command);
                item.setData((Object)enumFacet);
                item.setText((String)value);
            }
        }

        public Object getValue(Object element, String property) {
            if (element instanceof XSDEnumerationFacet) {
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)element;
                String value = enumFacet.getLexicalValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }
    }
}

