/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.editor;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ADTEditPartFactory;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BackToSchemaEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTContentOutlineProvider;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTLabelProvider;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public abstract class ADTMultiPageEditor
extends CommonMultiPageEditor {
    protected IModel model;
    private int currentPage = -1;
    protected Button tableOfContentsButton;
    GraphicalViewerImpl toolbarViewer;
    BackToSchemaEditPart backToSchemaEditPart;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected Composite createGraphPageComposite() {
        Composite parent = new Composite(this.getContainer(), 0x800000);
        parent.setLayout((Layout)new InternalLayout());
        this.toolbarViewer = new GraphicalViewerImpl();
        this.toolbarViewer.createControl(parent);
        this.toolbarViewer.getControl().setVisible(true);
        this.backToSchemaEditPart = new BackToSchemaEditPart(this);
        this.backToSchemaEditPart.setModel(this.getModel());
        this.toolbarViewer.setContents((EditPart)this.backToSchemaEditPart);
        return parent;
    }

    protected void createGraphPage() {
        super.createGraphPage();
        this.toolbarViewer.getControl().moveAbove(this.graphicalViewer.getControl());
        this.graphicalViewer.getControl().moveBelow(this.toolbarViewer.getControl());
    }

    public String getContributorId() {
        return "org.eclipse.wst.xsd.ui.internal.editor";
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) {
            ADTContentOutlinePage outlinePage = new ADTContentOutlinePage(this);
            ADTContentOutlineProvider adtContentProvider = new ADTContentOutlineProvider();
            outlinePage.setContentProvider(adtContentProvider);
            ADTLabelProvider adtLabelProvider = new ADTLabelProvider();
            outlinePage.setLabelProvider(adtLabelProvider);
            outlinePage.setModel(this.getModel());
            this.fOutlinePage = outlinePage;
        }
        return this.fOutlinePage;
    }

    protected void createPages() {
        this.selectionProvider = this.getSelectionManager();
        this.createGraphPage();
        this.createSourcePage();
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.model = this.buildModel();
        this.initializeGraphicalViewer();
        int pageIndexToShow = this.getDefaultPageTypeIndex();
        this.setActivePage(pageIndexToShow);
    }

    protected int getDefaultPageTypeIndex() {
        int pageIndex = SOURCE_PAGE_INDEX;
        if (XSDEditorPlugin.getPlugin().getDefaultPage().equals(XSDEditorPlugin.DESIGN_PAGE)) {
            pageIndex = DESIGN_PAGE_INDEX;
        }
        return pageIndex;
    }

    protected void pageChange(int newPageIndex) {
        this.currentPage = newPageIndex;
        super.pageChange(newPageIndex);
    }

    private boolean isTableOfContentsApplicable(Object graphViewInput) {
        return !(graphViewInput instanceof IModel);
    }

    protected ScrollingGraphicalViewer getGraphicalViewer() {
        DesignViewGraphicalViewer viewer = new DesignViewGraphicalViewer((IEditorPart)this, this.getSelectionManager());
        viewer.addInputChangdListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection input = (IStructuredSelection)event.getSelection();
                ADTMultiPageEditor.this.backToSchemaEditPart.setEnabled(ADTMultiPageEditor.this.isTableOfContentsApplicable(input.getFirstElement()));
                ADTMultiPageEditor.this.backToSchemaEditPart.setModel(ADTMultiPageEditor.this.getModel());
            }
        });
        return viewer;
    }

    public abstract IModel buildModel();

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        SetInputToGraphView action = new SetInputToGraphView((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)action);
    }

    public IModel getModel() {
        return this.model;
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.graphicalViewer.getProperty(clazz2.toString());
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.graphicalViewer;
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.gef.EditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4 && this.graphicalViewer != null) {
            return this.graphicalViewer.getRootEditPart();
        }
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.draw2d.IFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5 && this.graphicalViewer != null) {
            return ((GraphicalEditPart)this.graphicalViewer.getRootEditPart()).getFigure();
        }
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz6) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(type);
    }

    protected EditPartFactory getEditPartFactory() {
        return new ADTEditPartFactory();
    }

    protected void initializeGraphicalViewer() {
        this.graphicalViewer.setContents((Object)this.model);
    }

    public void dispose() {
        if (this.currentPage == SOURCE_PAGE_INDEX) {
            XSDEditorPlugin.getPlugin().setSourcePageAsDefault();
        } else {
            XSDEditorPlugin.getPlugin().setDesignPageAsDefault();
        }
        this.toolbarViewer = null;
        this.backToSchemaEditPart = null;
        super.dispose();
    }

    private class InternalLayout
    extends StackLayout {
        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Rectangle rect = composite.getClientArea();
            rect.x += this.marginWidth;
            rect.y += this.marginHeight;
            rect.width -= 2 * this.marginWidth;
            rect.height -= 2 * this.marginHeight;
            int i = 0;
            while (i < children.length) {
                if (i == 1) {
                    children[i].setBounds(rect);
                } else if (i == 0) {
                    children[i].setBounds(rect.x + 10, rect.y + 10, 25, 25);
                }
                ++i;
            }
        }
    }
}

