/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class EnterpriseBinaryComponentHelper
extends BinaryComponentHelper {
    private Archive archive = null;

    protected EnterpriseBinaryComponentHelper(IVirtualComponent component) {
        super(component);
    }

    protected ComponentArchiveOptions getArchiveOptions() {
        ComponentArchiveOptions options = new ComponentArchiveOptions(this.getComponent());
        options.setIsReadOnly(true);
        options.setRendererType(1);
        return options;
    }

    private Archive getUniqueArchive() {
        String archiveURI = this.getArchiveURI();
        try {
            return this.openArchive(archiveURI);
        }
        catch (OpenFailureException e) {
            Logger.getLogger().logError((Throwable)e);
            return null;
        }
    }

    public Archive getArchive() {
        if (this.archive == null) {
            this.archive = this.getUniqueArchive();
        }
        return this.archive;
    }

    protected boolean isArchiveValid() {
        boolean bl;
        block5: {
            if (this.archive != null) {
                return true;
            }
            Archive anArchive = null;
            try {
                anArchive = CommonarchiveFactory.eINSTANCE.primOpenArchive((ArchiveOptions)this.getArchiveOptions(), this.getArchiveURI());
                ArchiveTypeDiscriminator disc = this.getDiscriminator();
                bl = disc.canImport(anArchive);
                Object var3_4 = null;
                if (anArchive == null) break block5;
            }
            catch (Exception exception) {
                block6: {
                    try {
                        Object var3_5 = null;
                        if (anArchive == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var3_6 = null;
                            if (anArchive == null) break block7;
                            anArchive.close();
                        }
                        throw throwable;
                    }
                    anArchive.close();
                }
                return false;
            }
            anArchive.close();
        }
        return bl;
    }

    protected String getArchiveURI() {
        String archiveURI = null;
        VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)this.getComponent();
        File diskFile = archiveComp.getUnderlyingDiskFile();
        if (diskFile.exists()) {
            archiveURI = diskFile.getAbsolutePath();
        } else {
            IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
            archiveURI = iFile.getRawLocation().toOSString();
        }
        return archiveURI;
    }

    public void dispose() {
        if (this.archive != null) {
            if (this.archive.isOpen()) {
                this.archive.close();
            }
            this.archive = null;
        }
    }

    protected abstract ArchiveTypeDiscriminator getDiscriminator();

    protected abstract Archive openArchive(String var1) throws OpenFailureException;

    public Resource getResource(URI uri) {
        return this.getArchive().getResourceSet().getResource(uri, true);
    }

    public void releaseAccess(ArtifactEdit edit) {
        this.dispose();
    }
}

