/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class WSDLUtility {
    protected Definition definition_ = null;
    protected IResource resource_ = null;
    protected String serviceName_ = "";
    protected URL url_ = null;

    public WSDLUtility(IResource res) {
        this.resource_ = res;
        this.buildDefinition();
    }

    protected boolean buildDefinition() {
        String ext;
        if (this.resource_.getType() == 1 && (ext = this.resource_.getFileExtension()) != null && ext.equalsIgnoreCase("wsdl")) {
            String resPath = this.resource_.getFullPath().toString();
            WebServicesParser parser = new WebServicesParser();
            try {
                this.definition_ = parser.getWSDLDefinition("platform:" + resPath);
                if (this.definition_ == null) {
                    throw new Exception("WebServiceUtils.getWSDLAddress - error parsing platform:/resource" + resPath);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.serviceName_ = "";
        return true;
    }

    public String getServiceName() {
        if (this.serviceName_.equals("")) {
            Map servicesMap = this.definition_.getServices();
            Object[] services = servicesMap.values().toArray();
            int i = 0;
            while (i < services.length) {
                Service s = (Service)services[i];
                String qString = s.getQName().toString();
                int index1 = qString.indexOf("}") + 1;
                int index2 = qString.length();
                this.serviceName_ = qString.substring(index1, index2);
                ++i;
            }
        }
        return this.serviceName_;
    }

    public URL getWSDLAddress() {
        if (this.url_ == null) {
            String locationURI = null;
            Map servicesMap = this.definition_.getServices();
            Object[] services = servicesMap.values().toArray();
            int i = 0;
            while (i < services.length) {
                Service s = (Service)services[i];
                Map portsMap = s.getPorts();
                Object[] ports = portsMap.values().toArray();
                int j = 0;
                while (j < ports.length) {
                    Port p = (Port)ports[j];
                    List extList = p.getExtensibilityElements();
                    int k = 0;
                    while (j < extList.size()) {
                        ExtensibilityElement extElement = (ExtensibilityElement)extList.get(k);
                        if (extElement instanceof SOAPAddress) {
                            locationURI = ((SOAPAddress)extElement).getLocationURI();
                        } else if (extElement instanceof HTTPAddress) {
                            locationURI = ((HTTPAddress)extElement).getLocationURI();
                        }
                        ++j;
                    }
                    ++j;
                }
                ++i;
            }
            try {
                this.url_ = new URL(String.valueOf(locationURI) + "?" + this.resource_.getFileExtension());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.url_;
    }
}

