/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.internal.proxy;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.internet.internal.proxy.PasswordDialog;

public class ProxyAuthenticator
extends Authenticator {
    private Hashtable table = new Hashtable();
    private String address = null;
    private PasswordAuthentication auth = null;

    protected PasswordAuthentication getPasswordAuthentication() {
        this.address = null;
        this.auth = null;
        try {
            this.address = InetAddress.getByName(this.getRequestingHost()).getHostAddress();
            this.auth = (PasswordAuthentication)this.table.get(this.address);
        }
        catch (Exception exception) {}
        if (this.auth == null) {
            Display display = Display.getDefault();
            display.syncExec((Runnable)new PromptUserJob());
        }
        return this.auth;
    }

    public void addProxyEntry(String hostname, String userid, String password) {
        try {
            String address = InetAddress.getByName(hostname).getHostAddress();
            PasswordAuthentication auth = new PasswordAuthentication(userid, password.toCharArray());
            this.table.put(address, auth);
        }
        catch (Exception exception) {}
    }

    private class PromptUserJob
    implements Runnable {
        private PromptUserJob() {
        }

        public void run() {
            PasswordDialog dialog;
            int code;
            Display display = Display.getDefault();
            Shell shell = null;
            if (display != null) {
                shell = display.getActiveShell();
            }
            if ((code = (dialog = new PasswordDialog(shell, ProxyAuthenticator.this.getRequestingPrompt())).open()) == 0) {
                String username = dialog.getUsername();
                String password = dialog.getPassword();
                if (username != null && password != null && username.length() > 0 && password.length() > 0) {
                    ProxyAuthenticator.this.auth = new PasswordAuthentication(username, password.toCharArray());
                    if (ProxyAuthenticator.this.address != null) {
                        ProxyAuthenticator.this.table.put(ProxyAuthenticator.this.address, ProxyAuthenticator.this.auth);
                    }
                }
            }
        }
    }
}

