/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class CreateServerCommand
extends AbstractDataModelOperation {
    private String serverFactoryId;
    private String serverInstanceId;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.serverFactoryId == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_CREATE_SERVER);
            return status;
        }
        IServerWorkingCopy serverWC = null;
        IServer server = null;
        try {
            IServerType serverType = ServerCore.findServerType((String)this.serverFactoryId);
            if (serverType != null) {
                IRuntime nonStubRuntime = null;
                IRuntime[] runtimes = ServerUtil.getRuntimes(null, null);
                String serverRuntimeTypeId = serverType.getRuntimeType().getId();
                int i = 0;
                while (i < runtimes.length) {
                    IRuntime runtime = runtimes[i];
                    String thisRuntimeTypeId = runtime.getRuntimeType().getId();
                    if (thisRuntimeTypeId.equals(serverRuntimeTypeId) && !runtime.isStub()) {
                        nonStubRuntime = runtime;
                        break;
                    }
                    ++i;
                }
                if (nonStubRuntime == null) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_STUB_ONLY, (Object[])new String[]{this.serverFactoryId}));
                    return status;
                }
                serverWC = env != null ? serverType.createServer(null, null, nonStubRuntime, monitor) : serverType.createServer(null, null, nonStubRuntime, null);
                if (serverWC != null) {
                    server = env != null ? serverWC.saveAll(true, monitor) : serverWC.saveAll(true, null);
                }
            }
        }
        catch (CoreException ce) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_CREATE_SERVER, (Throwable)ce);
            return status;
        }
        if (server != null) {
            this.serverInstanceId = server.getId();
        } else {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_CREATE_SERVER);
        }
        return status;
    }

    public void setServerFactoryid(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public String getServerInstanceId() {
        return this.serverInstanceId;
    }
}

