/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.web.ui.internal.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WSTWebUIPlugin
extends AbstractUIPlugin {
    private static WSTWebUIPlugin plugin;
    public static final String[] ICON_DIRS;

    static {
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/ctool16", "icons/full/wizban", "icons", ""};
    }

    public WSTWebUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL imageURL = WSTWebUIPlugin.getImageURL(key, this.getBundle());
        if (imageURL == null) {
            imageURL = WSTWebUIPlugin.getPNGImageURL(key, this.getBundle());
        }
        if (imageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        }
        return imageDescriptor;
    }

    public static URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (bundle.getEntry(path.toString()) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    Logger.log(2, "Load_Image_Error_", exception);
                }
            }
            ++i;
        }
        return null;
    }

    public static URL getPNGImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".png";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (bundle.getEntry(path.toString()) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    Logger.log(2, "Load_Image_Error_", exception);
                }
            }
            ++i;
        }
        return null;
    }

    public static WSTWebUIPlugin getDefault() {
        return plugin;
    }
}

