/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.page.TasksLayout;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class TasksComposite
extends Composite {
    protected IWizardHandle wizard;
    protected Composite comp;
    protected List tasks;
    protected boolean created;

    public TasksComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizTaskTitle);
        wizard.setDescription(Messages.wizTaskDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("selectServer"));
    }

    public void setTasks(List tasks) {
        this.tasks = tasks;
        Control[] children = this.getChildren();
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                children[i].dispose();
                ++i;
            }
        }
        this.created = false;
    }

    public void createControl() {
        if (this.created) {
            return;
        }
        TasksLayout layout = new TasksLayout(SWTUtil.convertVerticalDLUsToPixels(this, 4));
        this.setLayout(layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.wst.server.ui.sstw0000");
        int size = 0;
        if (this.tasks != null) {
            size = this.tasks.size();
        }
        int i = 0;
        while (i < size) {
            Object obj = this.tasks.get(i);
            final TasksWizardFragment.TaskInfo sti = (TasksWizardFragment.TaskInfo)obj;
            final Button checkbox = new Button((Composite)this, 96);
            String label = sti.task2.getLabel();
            if (label != null) {
                checkbox.setText(label);
            } else {
                checkbox.setText(Messages.elementUnknownName);
            }
            checkbox.setFocus();
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    sti.setSelected(checkbox.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    sti.setSelected(checkbox.getSelection());
                }
            });
            Label description = new Label((Composite)this, 64);
            String desc = sti.task2.getDescription();
            if (desc != null) {
                description.setText(desc);
            } else {
                description.setText(Messages.elementUnknownName);
            }
            if (sti.kind == 2) {
                checkbox.setSelection(true);
                checkbox.setEnabled(false);
            } else {
                checkbox.setSelection(sti.getDefaultSelected());
            }
            ++i;
        }
        if (size == 0) {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.wizTaskNone);
        }
        Dialog.applyDialogFont((Control)this);
        this.layout(true, true);
        this.created = true;
    }
}

