/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class SelectClientComposite
extends Composite {
    protected IWizardHandle wizard;
    protected IClient[] clients;
    protected IClient selectedClient;
    protected Table elementTable;
    protected Label description;

    public SelectClientComposite(Composite parent, IWizardHandle wizard, IClient[] clients) {
        super(parent, 0);
        this.wizard = wizard;
        this.clients = clients;
        wizard.setTitle(Messages.wizSelectClientTitle);
        wizard.setDescription(Messages.wizSelectClientDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("wizClient"));
        this.createControl();
    }

    public void clearSelectedClient() {
        this.selectedClient = null;
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swsc0000");
        Label label = new Label((Composite)this, 64);
        label.setText(Messages.wizSelectClientMessage);
        GridData data = new GridData(258);
        label.setLayoutData((Object)data);
        this.elementTable = new Table((Composite)this, 2816);
        data = new GridData(770);
        data.heightHint = 80;
        data.horizontalIndent = 20;
        this.elementTable.setLayoutData((Object)data);
        this.elementTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectClientComposite.this.handleSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectClientComposite.this.handleSelection();
            }
        });
        whs.setHelp((Control)this.elementTable, "org.eclipse.wst.server.ui.swsc0002");
        if (this.clients != null) {
            int size = this.clients.length;
            int i = 0;
            while (i < size) {
                TableItem item = new TableItem(this.elementTable, 0);
                item.setText(0, ServerUICore.getLabelProvider().getText((Object)this.clients[i]));
                item.setImage(0, ServerUICore.getLabelProvider().getImage((Object)this.clients[i]));
                item.setData((Object)this.clients[i]);
                ++i;
            }
        }
        this.description = new Label((Composite)this, 64);
        this.description.setText("");
        data = new GridData(258);
        data.heightHint = 70;
        this.description.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this);
    }

    public IClient getSelectedClient() {
        return this.selectedClient;
    }

    protected void handleSelection() {
        int index = this.elementTable.getSelectionIndex();
        this.selectedClient = index < 0 ? null : this.clients[index];
        if (this.selectedClient != null) {
            this.wizard.setMessage(null, 0);
        } else {
            this.wizard.setMessage("", 3);
        }
        String desc = null;
        if (this.selectedClient != null) {
            desc = this.selectedClient.getDescription();
        }
        if (desc == null) {
            desc = "";
        }
        this.description.setText(desc);
        this.wizard.update();
    }
}

