/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class ServerTreeContentProvider
extends AbstractTreeContentProvider {
    public static final byte STYLE_HOST = 1;
    public static final byte STYLE_VENDOR = 2;
    public static final byte STYLE_VERSION = 3;
    protected IModule module;
    protected String launchMode;
    protected boolean includeIncompatibleVersions;

    public ServerTreeContentProvider(byte style) {
        super(style);
    }

    public ServerTreeContentProvider(byte style, IModule module, String launchMode) {
        super(style, false);
        this.module = module;
        this.launchMode = launchMode;
        this.fillTree();
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        this.fillTree();
    }

    protected void fillTree() {
        this.clean();
        ArrayList<IServer> list = new ArrayList<IServer>();
        if (this.style != 0) {
            IServer[] servers = ServerCore.getServers();
            if (servers != null) {
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    if (this.acceptServer(servers[i])) {
                        IServerType serverType = servers[i].getServerType();
                        IRuntimeType runtimeType = serverType.getRuntimeType();
                        AbstractTreeContentProvider.TreeElement te = null;
                        if (this.style == 1) {
                            te = this.getOrCreate(list, servers[i].getHost());
                        } else if (this.style == 3) {
                            String version = Messages.elementUnknownName;
                            if (runtimeType != null) {
                                version = runtimeType.getVersion();
                            }
                            te = this.getOrCreate(list, version);
                        } else if (this.style == 2) {
                            String vendor = Messages.elementUnknownName;
                            if (runtimeType != null) {
                                vendor = runtimeType.getVendor();
                            }
                            te = this.getOrCreate(list, vendor);
                        }
                        te.contents.add(servers[i]);
                        this.elementToParentMap.put(servers[i], te);
                    }
                    ++i;
                }
            }
        } else {
            IServer[] servers = ServerCore.getServers();
            if (servers != null) {
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    if (this.acceptServer(servers[i])) {
                        list.add(servers[i]);
                    }
                    ++i;
                }
            }
        }
        this.elements = list.toArray();
    }

    protected boolean acceptServer(IServer server) {
        if (this.module == null || this.launchMode == null) {
            return true;
        }
        if (!ServerUIPlugin.isCompatibleWithLaunchMode(server, this.launchMode)) {
            return false;
        }
        IModuleType mt = this.module.getModuleType();
        return !(this.includeIncompatibleVersions ? !ServerUtil.isSupportedModule((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes(), (String)mt.getId(), null) : !ServerUtil.isSupportedModule((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes(), (String)mt.getId(), (String)mt.getVersion()));
    }
}

