/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class DeleteServerDialog
extends Dialog {
    protected IServer[] servers;
    protected IFolder[] configs;
    protected List runningServersList;
    protected Button checkDeleteConfigs;
    protected Button checkDeleteRunning;
    protected Button checkDeleteRunningStop;

    public DeleteServerDialog(Shell parentShell, IServer[] servers, IFolder[] configs) {
        super(parentShell);
        if (servers == null || configs == null) {
            throw new IllegalArgumentException();
        }
        this.servers = servers;
        this.configs = configs;
        this.runningServersList = new ArrayList();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerState() != 4) {
                this.runningServersList.add(servers[i]);
            }
            ++i;
        }
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.deleteServerDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        int size;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        if (this.servers.length == 1) {
            label.setText(NLS.bind((String)Messages.deleteServerDialogMessage, (Object)this.servers[0].getName()));
        } else {
            label.setText(NLS.bind((String)Messages.deleteServerDialogMessageMany, (Object)String.valueOf(this.servers.length)));
        }
        if (this.configs.length > 0) {
            this.checkDeleteConfigs = new Button(composite, 32);
            this.checkDeleteConfigs.setText(NLS.bind((String)Messages.deleteServerDialogLooseConfigurations, (Object)this.configs[0].getName()));
            this.checkDeleteConfigs.setSelection(true);
        }
        if ((size = this.runningServersList.size()) > 0) {
            this.checkDeleteRunning = new Button(composite, 32);
            this.checkDeleteRunning.setText(NLS.bind((String)Messages.deleteServerDialogRunningServer, (Object)((IServer)this.runningServersList.get(0)).getName()));
            this.checkDeleteRunning.setSelection(true);
            this.checkDeleteRunningStop = new Button(composite, 32);
            this.checkDeleteRunningStop.setText(NLS.bind((String)Messages.deleteServerDialogRunningServerStop, (Object)((IServer)this.runningServersList.get(0)).getName()));
            this.checkDeleteRunningStop.setSelection(true);
            GridData data = new GridData();
            data.horizontalIndent = 15;
            this.checkDeleteRunningStop.setLayoutData((Object)data);
            this.checkDeleteRunning.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteServerDialog.this.checkDeleteRunningStop.setEnabled(DeleteServerDialog.this.checkDeleteRunning.getSelection());
                }
            });
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        boolean deleteRunningStop;
        final boolean checked = this.checkDeleteConfigs != null && this.checkDeleteConfigs.getSelection();
        boolean deleteRunning = this.checkDeleteRunning != null && this.checkDeleteRunning.getSelection();
        boolean bl = deleteRunningStop = this.checkDeleteRunningStop != null && this.checkDeleteRunningStop.getSelection();
        if (this.runningServersList.size() > 0) {
            this.prepareForDeletion(deleteRunning, deleteRunningStop);
        }
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask(Messages.deleteServerTask, 2);
                    if (DeleteServerDialog.this.servers.length == 0) {
                        return;
                    }
                    try {
                        int size = DeleteServerDialog.this.servers.length;
                        int i = 0;
                        while (i < size) {
                            DeleteServerDialog.this.servers[i].delete();
                            ++i;
                        }
                        if (checked) {
                            size = DeleteServerDialog.this.configs.length;
                            i = 0;
                            while (i < size) {
                                DeleteServerDialog.this.configs[i].delete(true, true, monitor);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error while deleting resources", e);
                    }
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error deleting resources", e);
        }
        super.okPressed();
    }

    protected void prepareForDeletion(boolean deleteRunning, boolean stopRunning) {
        LinkedList<IServer> serversList = new LinkedList<IServer>(Arrays.asList(this.servers));
        LinkedList<IFolder> configsList = new LinkedList<IFolder>(Arrays.asList(this.configs));
        if (!deleteRunning) {
            int size = this.runningServersList.size();
            int i = 0;
            while (i < size) {
                IServer server = (IServer)this.runningServersList.get(i);
                serversList.remove(server);
                if (server.getServerConfiguration() != null) {
                    configsList.remove(server.getServerConfiguration());
                }
                ++i;
            }
        } else if (stopRunning) {
            MultiServerStopListener listener = new MultiServerStopListener();
            int expected = 0;
            Iterator iter = this.runningServersList.iterator();
            while (iter.hasNext()) {
                IServer s = (IServer)iter.next();
                if (s.canStop().isOK()) {
                    ++expected;
                    s.stop(false, (IServer.IOperationListener)listener);
                    continue;
                }
                serversList.remove(s);
                configsList.remove(s.getServerConfiguration());
            }
            try {
                while (expected != listener.getNumberStopped()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.trace(Trace.WARNING, "Interrupted while waiting for servers stop");
            }
        }
        this.servers = new IServer[serversList.size()];
        serversList.toArray(this.servers);
        this.configs = new IFolder[configsList.size()];
        configsList.toArray(this.configs);
    }

    class MultiServerStopListener
    implements IServer.IOperationListener {
        protected int num;

        MultiServerStopListener() {
        }

        public void done(IStatus result) {
            ++this.num;
        }

        public int getNumberStopped() {
            return this.num;
        }
    }
}

