/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLCommonElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Node;

public class WSDLElement
extends WSDLCommonElement {
    private String wsdlUrl_;
    private Definition definition_;
    private Vector schemaList_;
    private Vector schemaURI_;
    private static Vector w3SchemaQNameList_ = new Vector();
    private static Vector constantSchemaList_;

    static {
        w3SchemaQNameList_.addElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        w3SchemaQNameList_.addElement(new QName("http://www.w3.org/2000/10/XMLSchema", "schema"));
        w3SchemaQNameList_.addElement(new QName("http://www.w3.org/1999/XMLSchema", "schema"));
        constantSchemaList_ = new Vector();
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2000/10/XMLSchema"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/1999/XMLSchema"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://schemas.xmlsoap.org/soap/encoding/"));
        constantSchemaList_.addElement(XSDSchemaImpl.getSchemaForSchema((String)"http://schemas.xmlsoap.org/wsdl/"));
    }

    public WSDLElement(String name, Model model, String wsdlUrl) {
        super(name, model);
        this.wsdlUrl_ = wsdlUrl;
        this.definition_ = null;
        this.schemaList_ = new Vector();
        this.schemaURI_ = new Vector();
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl_ = wsdlUrl;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl_;
    }

    public void setSchemaList(Vector schemaList) {
        this.schemaList_ = schemaList;
    }

    public Vector getSchemaList() {
        return this.schemaList_;
    }

    private final Definition loadWSDL(String wsdlURL) throws WSDLException {
        WebServicesParserExt parser = new WebServicesParserExt();
        try {
            return parser.getWSDLDefinitionVerbose(wsdlURL);
        }
        catch (WSDLException wsdle) {
            throw wsdle;
        }
        catch (Throwable t) {
            throw new WSDLException("OTHER_ERROR", t.getMessage(), t);
        }
    }

    public Vector loadWSDL() throws WSDLException {
        Vector<String> errorMessages = new Vector<String>();
        this.definition_ = this.loadWSDL(this.wsdlUrl_);
        if (this.definition_ != null) {
            this.setDocumentation(this.definition_.getDocumentationElement());
            this.gatherSchemas(this.definition_, this.wsdlUrl_);
            int i = 0;
            while (i < this.schemaList_.size()) {
                XSDSchema xsdSchema = (XSDSchema)this.schemaList_.elementAt(i);
                xsdSchema.validate();
                EList errors = xsdSchema.getAllDiagnostics();
                if (!errors.isEmpty()) {
                    ListIterator li = errors.listIterator();
                    while (li.hasNext()) {
                        XSDDiagnostic xd = (XSDDiagnostic)li.next();
                        String msg = xd.getMessage();
                        if (xd.getSeverity().getValue() == XSDDiagnosticSeverity.FATAL_LITERAL.getValue() || msg != null && msg.length() > 0 && msg.toLowerCase().indexOf("#array") != -1) {
                            li.remove();
                            continue;
                        }
                        if (msg == null || msg.length() <= 0) continue;
                        errorMessages.addElement(xd.getMessage());
                    }
                }
                ++i;
            }
            i = 0;
            while (i < constantSchemaList_.size()) {
                this.schemaList_.addElement(constantSchemaList_.elementAt(i));
                ++i;
            }
        }
        return errorMessages;
    }

    private final void gatherSchemas(Definition definition, String definitionURL) {
        Map imports;
        List extTypes;
        Types types = definition.getTypes();
        if (types != null && (extTypes = types.getExtensibilityElements()) != null) {
            int i = 0;
            while (i < extTypes.size()) {
                XSDSchema xsdSchema;
                UnknownExtensibilityElement schemaElement;
                Object obj = extTypes.get(i);
                if (obj instanceof UnknownExtensibilityElement) {
                    schemaElement = (UnknownExtensibilityElement)obj;
                    if (this.isW3SchemaElementType(schemaElement.getElementType())) {
                        xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                        if (!this.checkSchemaURI(definitionURL)) {
                            this.schemaList_.addElement(xsdSchema);
                            this.gatherSchemaDirective(xsdSchema, definitionURL);
                        }
                    }
                } else if (obj instanceof XSDSchemaExtensibilityElementImpl) {
                    schemaElement = (XSDSchemaExtensibilityElementImpl)obj;
                    xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    if (!this.checkSchemaURI(definitionURL)) {
                        this.schemaList_.addElement(xsdSchema);
                        this.gatherSchemaDirective(xsdSchema, definitionURL);
                    }
                }
                ++i;
            }
        }
        if ((imports = definition.getImports()) != null) {
            this.gatherImportedSchemas(definition, imports);
        }
    }

    private final void gatherSchemaDirective(XSDSchema xsdSchema, String xsdSchemaURL) {
        if (xsdSchema != null) {
            EList xsdSchemaContents = xsdSchema.getContents();
            Iterator it = xsdSchemaContents.iterator();
            while (it.hasNext()) {
                Object content = it.next();
                if (!(content instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective xsdSchemaDirective = (XSDSchemaDirective)content;
                StringBuffer xsdSchemaDirectiveURL = new StringBuffer();
                String xsdSchemaDirectiveLocation = xsdSchemaDirective.getSchemaLocation();
                if (xsdSchemaDirectiveLocation != null && xsdSchemaDirectiveLocation.indexOf(58) == -1 && xsdSchemaURL != null && xsdSchemaURL.indexOf(58) != -1) {
                    int index = xsdSchemaURL.lastIndexOf(47);
                    if (index != -1) {
                        xsdSchemaDirectiveURL.append(xsdSchemaURL.substring(0, index + 1));
                    } else {
                        xsdSchemaDirectiveURL.append(xsdSchemaURL);
                        xsdSchemaDirectiveURL.append('/');
                    }
                }
                xsdSchemaDirectiveURL.append(xsdSchemaDirectiveLocation);
                XSDSchema resolvedSchema = xsdSchemaDirective.getResolvedSchema();
                if (resolvedSchema == null && xsdSchemaDirectiveURL.length() > 0) {
                    resolvedSchema = this.getSchema(xsdSchemaDirectiveURL.toString());
                }
                if (resolvedSchema == null || this.checkSchemaURI(xsdSchemaDirectiveURL.toString())) continue;
                this.schemaList_.addElement(resolvedSchema);
                this.gatherSchemaDirective(resolvedSchema, xsdSchemaDirectiveURL.toString());
            }
        }
    }

    private boolean checkSchemaURI(String schemaURI) {
        boolean found = false;
        if ((schemaURI = this.normalize(schemaURI)).equals(this.normalize(this.wsdlUrl_))) {
            return false;
        }
        Enumeration e = this.schemaURI_.elements();
        while (e.hasMoreElements()) {
            String uri = (String)e.nextElement();
            if (!schemaURI.equals(uri)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.schemaURI_.addElement(schemaURI);
        }
        return found;
    }

    private String normalize(String uri) {
        try {
            String encodedURI = URIEncoder.encode((String)uri, (String)"UTF-8");
            URI normalizedURI = new URI(encodedURI);
            normalizedURI = normalizedURI.normalize();
            return normalizedURI.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uri;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return uri;
        }
    }

    private final boolean isW3SchemaElementType(QName qname) {
        int i = 0;
        while (i < w3SchemaQNameList_.size()) {
            QName w3SchemaQName = (QName)w3SchemaQNameList_.elementAt(i);
            if (w3SchemaQName.equals(qname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final void gatherImportedSchemas(Definition definition, Map imports) {
        Iterator iterator = imports.keySet().iterator();
        while (iterator.hasNext()) {
            List importList = (List)imports.get(iterator.next());
            int i = 0;
            while (i < importList.size()) {
                Import imp = (Import)importList.get(i);
                StringBuffer locURI = new StringBuffer(imp.getLocationURI());
                if (!Validator.validateURL(locURI.toString())) {
                    String base = definition.getDocumentBaseURI();
                    locURI.insert(0, base.substring(0, base.lastIndexOf(47) + 1));
                }
                try {
                    Definition importDef = this.loadWSDL(locURI.toString());
                    this.gatherSchemas(importDef, locURI.toString());
                }
                catch (WSDLException wSDLException) {
                    this.gatherSchema(locURI.toString());
                }
                ++i;
            }
        }
    }

    private final void gatherSchema(String locURI) {
        XSDSchema xsdSchema = this.getSchema(locURI);
        if (xsdSchema != null) {
            this.schemaList_.addElement(xsdSchema);
            this.gatherSchemaDirective(xsdSchema, locURI);
        }
    }

    private final XSDSchema getSchema(String locURI) {
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)locURI);
        if (xsdSchema == null) {
            XSDParser p = new XSDParser();
            InputStream is = NetUtils.getURLInputStream((String)locURI);
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        return xsdSchema;
    }

    public void setDefinition(Definition definition) {
        this.definition_ = definition;
    }

    public Definition getDefinition() {
        return this.definition_;
    }

    public void buildModel() {
        if (this.definition_ != null) {
            HashMap services = new HashMap(this.definition_.getServices());
            WSDLServiceElement[] wsdlServiceElements = new WSDLServiceElement[this.getNumberOfElements("relWSDLService")];
            Enumeration e = this.getElements("relWSDLService");
            int i = 0;
            while (i < wsdlServiceElements.length) {
                wsdlServiceElements[i] = (WSDLServiceElement)((Object)e.nextElement());
                ++i;
            }
            int j = 0;
            while (j < wsdlServiceElements.length) {
                QName qname = wsdlServiceElements[j].getService().getQName();
                Service service = (Service)services.get(qname);
                if (service != null) {
                    services.remove(qname);
                    wsdlServiceElements[j].setService(service);
                    wsdlServiceElements[j].buildModel();
                } else {
                    this.disconnect((Element)wsdlServiceElements[j], "relWSDLService");
                }
                ++j;
            }
            Iterator it = services.values().iterator();
            while (it.hasNext()) {
                Service service = (Service)it.next();
                WSDLServiceElement wsdlServiceElement = new WSDLServiceElement(service.getQName().getLocalPart(), this.getModel(), service);
                this.connect((Element)wsdlServiceElement, "relWSDLService", "owner");
                wsdlServiceElement.buildModel();
            }
        }
    }
}

