/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public abstract class ProjectModuleFactoryDelegate
extends ModuleFactoryDelegate {
    private static List factories = new ArrayList();
    private List modules;

    public ProjectModuleFactoryDelegate() {
        factories.add(this);
    }

    private final void cacheModules() {
        if (this.modules != null) {
            return;
        }
        try {
            this.clearCache();
            IProject[] projects2 = ProjectModuleFactoryDelegate.getWorkspaceRoot().getProjects();
            int size = projects2.length;
            this.modules = new ArrayList(size);
            int i = 0;
            while (i < size) {
                if (projects2[i].isAccessible()) {
                    try {
                        IModule module = this.createModule(projects2[i]);
                        if (module != null) {
                            this.modules.add(module);
                        }
                    }
                    catch (Throwable t) {
                        Trace.trace(Trace.SEVERE, "Error creating module", t);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error caching modules", e);
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final IModule[] getModules() {
        this.cacheModules();
        IModule[] modules2 = new IModule[this.modules.size()];
        this.modules.toArray(modules2);
        return modules2;
    }

    public static final void handleGlobalProjectChange(IProject project, IResourceDelta delta) {
        ModuleFactory[] factories2 = ServerPlugin.getModuleFactories();
        int size = factories2.length;
        int i = 0;
        while (i < size) {
            ProjectModuleFactoryDelegate pmfd;
            if (factories2[i].delegate != null && factories2[i].delegate instanceof ProjectModuleFactoryDelegate && (pmfd = (ProjectModuleFactoryDelegate)factories2[i].delegate).deltaAffectsModules(delta)) {
                pmfd.modules = null;
                factories2[i].clearModuleCache();
            }
            ++i;
        }
    }

    private final boolean deltaAffectsModules(IResourceDelta delta) {
        class Temp {
            boolean b;
            final /* synthetic */ ProjectModuleFactoryDelegate this$0;

            Temp(ProjectModuleFactoryDelegate projectModuleFactoryDelegate) {
                this.this$0 = projectModuleFactoryDelegate;
                this.b = false;
            }
        }
        final Temp t = new Temp(this);
        final IPath[] listenerPaths = this.getListenerPaths();
        if (listenerPaths == null || listenerPaths.length == 0) {
            return false;
        }
        final int size = listenerPaths.length;
        try {
            delta.accept(new IResourceDeltaVisitor(){
                {
                }

                public boolean visit(IResourceDelta delta2) throws CoreException {
                    if (t.b) {
                        return false;
                    }
                    boolean ok = false;
                    IPath path = delta2.getProjectRelativePath();
                    int i = 0;
                    while (i < size) {
                        if (listenerPaths[i].equals((Object)path)) {
                            t.b = true;
                            return false;
                        }
                        if (path.isPrefixOf(listenerPaths[i])) {
                            ok = true;
                        }
                        ++i;
                    }
                    return ok;
                }
            });
        }
        catch (Exception exception) {}
        return t.b;
    }

    protected void clearCache() {
    }

    protected abstract IModule createModule(IProject var1);

    protected IPath[] getListenerPaths() {
        return null;
    }
}

