/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.xml.sax.SAXException;

public class BP2703
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2703(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        try {
            Definition def = (Definition)entryContext.getEntry().getEntryDetail();
            if (def == null) {
                throw new AssertionFailException("Definition null");
            }
            String wsdlURI = entryContext.getEntry().getReferenceID();
            Map namespaces = def.getNamespaces();
            Iterator iter = namespaces.values().iterator();
            while (iter.hasNext()) {
                String ns = (String)iter.next();
                if ("http://schemas.xmlsoap.org/wsdl/".equalsIgnoreCase(ns)) {
                    XMLUtils.parseXMLDocument(wsdlURI, TestUtils.getWSDLSchemaLocation());
                }
                if (!"http://schemas.xmlsoap.org/wsdl/soap/".equalsIgnoreCase(ns)) continue;
                XMLUtils.parseXMLDocument(wsdlURI, TestUtils.getWSDLSOAPSchemaLocation());
            }
        }
        catch (WSIException e) {
            if (e.getTargetException() instanceof SAXException) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(e.getTargetException()), entryContext);
            }
        }
        catch (Exception e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(e), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

