/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.Map;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.commands.AddTypesCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;

public final class AddXSDSchemaCommand
extends WSDLElementCommand {
    private Definition definition;
    private XSDSchemaExtensibilityElement extensibilityElement;
    private String targetNamespace;

    public AddXSDSchemaCommand(Definition definition) {
        this.definition = definition;
        this.targetNamespace = definition.getTargetNamespace();
    }

    public AddXSDSchemaCommand(Definition definition, String targetNamespace) {
        this.definition = definition;
        this.targetNamespace = targetNamespace;
    }

    public void run() {
        this.extensibilityElement = WSDLFactory.eINSTANCE.createXSDSchemaExtensibilityElement();
        this.extensibilityElement.setEnclosingDefinition(this.definition);
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        xsdSchema.setTargetNamespace(this.targetNamespace);
        Map qNamePrefixToNamespaceMap = xsdSchema.getQNamePrefixToNamespaceMap();
        qNamePrefixToNamespaceMap.put(xsdSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        this.extensibilityElement.setSchema(xsdSchema);
        Types types = this.getTypes();
        types.addExtensibilityElement((ExtensibilityElement)this.extensibilityElement);
    }

    private Types getTypes() {
        Types types = (Types)this.definition.getTypes();
        if (types != null) {
            return types;
        }
        AddTypesCommand command = new AddTypesCommand(this.definition);
        command.run();
        return (Types)command.getWSDLElement();
    }

    public WSDLElement getWSDLElement() {
        return this.extensibilityElement;
    }
}

