/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.ISelectionMapper;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessage;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.INamedObject;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ASDAbstractSection;
import org.eclipse.wst.wsdl.ui.internal.refactor.actions.RenameComponentAction;

public class NameSection
extends ASDAbstractSection
implements IHyperlinkListener {
    CLabel nameLabel;
    protected Text nameText;
    protected ImageHyperlink renameHyperlink;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace);
        data.top = new FormAttachment(0, 0);
        this.nameText.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages.getString("_UI_LABEL_NAME")) + ":");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.nameText, -5);
        data.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.nameText.addListener(24, (Listener)this);
    }

    private void showRefactorButton() {
        if (this.isReadOnly) {
            return;
        }
        if (this.renameHyperlink == null) {
            this.renameHyperlink = this.getWidgetFactory().createImageHyperlink(this.composite, 0);
            this.renameHyperlink.setImage(WSDLEditorPlugin.getInstance().getImage("icons/quickassist.gif"));
            this.renameHyperlink.setToolTipText(Messages.getString("_UI_TOOLTIP_RENAME_REFACTOR"));
            this.renameHyperlink.addHyperlinkListener((IHyperlinkListener)this);
        }
        FormData data = new FormData();
        data.right = new FormAttachment(100, -this.rightMarginSpace);
        data.top = new FormAttachment(0, 0);
        this.renameHyperlink.setLayoutData((Object)data);
        data = (FormData)this.nameText.getLayoutData();
        FormAttachment right = data.right;
        right.control = this.renameHyperlink;
        right.offset = -5;
        right.alignment = 16384;
        data.top = new FormAttachment((Control)this.renameHyperlink, 0, 0x1000000);
        this.renameHyperlink.setVisible(true);
    }

    private void hideRefactorButton() {
        if (this.isReadOnly) {
            return;
        }
        if (this.renameHyperlink == null) {
            return;
        }
        FormData data = (FormData)this.nameText.getLayoutData();
        FormAttachment right = data.right;
        right.control = null;
        right.numerator = 100;
        right.offset = -this.rightMarginSpace;
        data.top = new FormAttachment(0, 0);
        this.renameHyperlink.setVisible(false);
    }

    public void refresh() {
        super.refresh();
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        this.nameText.setText("");
        String name = "";
        if (this.getModel() instanceof INamedObject) {
            name = ((INamedObject)this.getModel()).getName();
        } else if (this.getModel() instanceof EditPart) {
            Object model = ((EditPart)this.getModel()).getModel();
            name = ((INamedObject)model).getName();
        }
        this.nameText.setText(name);
        this.setControlForegroundColor((Control)this.nameText);
        if (this.canRefactor()) {
            this.showRefactorButton();
        } else {
            this.hideRefactorButton();
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText && !this.nameText.isDisposed()) {
            String newValue = this.nameText.getText();
            Object model = this.getModel();
            INamedObject namedObject = null;
            if (model instanceof INamedObject) {
                namedObject = (INamedObject)model;
            }
            if (namedObject != null) {
                Command command = namedObject.getSetNameCommand(newValue);
                this.executeCommand(command);
            }
        }
    }

    private void invokeRenameRefactoring() {
        ISelectionMapper mapper;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.Definition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Definition definition = (Definition)editor.getAdapter((Class)clazz);
        ISelection selection = editor.getSite().getSelectionProvider().getSelection();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.wsdl.ui.internal.ISelectionMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        selection = (mapper = (ISelectionMapper)editor.getAdapter((Class)clazz2)) != null ? mapper.mapSelection(selection) : selection;
        RenameComponentAction action = new RenameComponentAction(selection, definition);
        action.update(selection);
        action.run();
    }

    private Object getRealModel() {
        Object realModel = this.getModel();
        if (realModel instanceof EditPart) {
            realModel = ((EditPart)this.getModel()).getModel();
        }
        return realModel;
    }

    private boolean canRefactor() {
        Object model = this.getRealModel();
        boolean canRefactor = model instanceof IMessage || model instanceof IBinding || model instanceof IInterface;
        return canRefactor;
    }

    public void linkActivated(HyperlinkEvent e) {
        this.invokeRenameRefactoring();
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }
}

