/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.ClientWizardWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;

public class ServerWizardWidgetDefaultingCommand
extends ClientWizardWidgetDefaultingCommand {
    private TypeRuntimeServer typeRuntimeServer_;
    private IStructuredSelection initialSelection_;
    private int serviceGeneration_;
    private boolean developService_;
    private boolean assembleService_;
    private boolean deployService_;
    IProject project_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        String type = this.getScenarioContext().getWebServiceType();
        String runtime = WebServiceRuntimeExtensionUtils2.getDefaultRuntimeValueFor((String)type);
        String factoryID = WebServiceRuntimeExtensionUtils2.getDefaultServerValueFor((String)type);
        this.typeRuntimeServer_ = new TypeRuntimeServer();
        this.typeRuntimeServer_.setTypeId(type);
        this.typeRuntimeServer_.setRuntimeId(runtime);
        this.typeRuntimeServer_.setServerId(factoryID);
        String[] typeIds = WebServiceRuntimeExtensionUtils2.getWebServiceTypeBySelection((IStructuredSelection)this.initialSelection_);
        if (typeIds != null && typeIds.length > 0) {
            this.typeRuntimeServer_.setTypeId(typeIds[0]);
        }
        this.serviceGeneration_ = this.getScenarioContext().getGenerateWebService();
        this.developService_ = this.serviceGeneration_ <= 5;
        this.assembleService_ = this.serviceGeneration_ <= 4;
        this.deployService_ = this.serviceGeneration_ <= 3;
        this.defaultClientScale();
        return Status.OK_STATUS;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection_ = selection;
    }

    public IStructuredSelection getInitialSelection() {
        return this.initialSelection_;
    }

    public IProject getInitialProject() {
        if (this.project_ == null) {
            this.project_ = this.getProjectFromObjectSelection(this.initialSelection_);
        }
        return this.project_;
    }

    private IProject getProjectFromObjectSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            IResource resource;
            block4: {
                try {
                    resource = ResourceUtils.getResourceFromSelection((Object)obj);
                    if (resource != null) break block4;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
            return p;
        }
        return null;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.typeRuntimeServer_;
    }

    public Boolean getInstallService() {
        return new Boolean(this.getScenarioContext().getInstallWebService());
    }

    public Boolean getStartService() {
        return new Boolean(this.getScenarioContext().getStartWebService());
    }

    public Boolean getTestService() {
        return new Boolean(this.getScenarioContext().getTestWebService());
    }

    public Boolean getPublishService() {
        return new Boolean(this.getScenarioContext().getLaunchWebServiceExplorer());
    }

    public Boolean getGenerateProxy() {
        return new Boolean(this.getScenarioContext().getGenerateProxy());
    }

    public boolean getRunTestClient() {
        return this.getScenarioContext().isLaunchSampleEnabled();
    }

    public Boolean getMonitorService() {
        return new Boolean(this.getScenarioContext().getMonitorWebService());
    }

    public int getServiceGeneration() {
        return this.serviceGeneration_;
    }

    public int getClientGeneration() {
        return this.getScenarioContext().getGenerateClient();
    }

    public boolean getDevelopService() {
        return this.developService_;
    }

    public boolean getAssembleService() {
        return this.assembleService_;
    }

    public boolean getDeployService() {
        return this.deployService_;
    }
}

