/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.FolderResourceFilter;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ClientTestWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private String INFOPOP_PWSM_PAGE = "PWSM0001";
    private Button testCheckbox_;
    private String INFOPOP_PWSM_CHECKBOX_TEST = "PWSM0002";
    private Combo testTypeCombo_;
    private String INFOPOP_PWSM_COMBOBOX_TEST = "PWSM0003";
    private Text jspFolderText_;
    private String INFOPOP_PWSM_TEXT_JSP_FOLDER = "PWSM0008";
    private Button sampleFolderBrowseButton_;
    private String INFOPOP_PWSM_BUTTON_JSP_FOLDER_BROWSE = "PWSM0009";
    private Combo projectCombo_;
    private String INFOPOP_PWSM_COMBO_PROJECT = "PWSM0010";
    private Tree methodsTree_;
    private Button selectAllMethodsButton_;
    private String INFOPOP_PWSM_BUTTON_SELECT_ALL = "PWSM0006";
    private Button deselectAllMethodsButton_;
    private String INFOPOP_PWSM_BUTTON_DESELECT_ALL = "PWSM0007";
    private Text sampleFolderText_;
    private String INFOPOP_PWSM_TEXT_SAMPLE_FOLDER = "PWSM0014";
    private Button runTestCheckbox_;
    private String INFOPOP_PWSM_CHECKBOX_LAUNCH = "PWSM0015";
    private Combo earCombo_;
    private String INFOPOP_PWSM_EAR_COMBO = "PWSM0016";
    private Composite comboGroup_;
    private SelectionList testFacilities_;
    private FolderResourceFilter folderFilter_ = new FolderResourceFilter();
    private IStructuredSelection initialSelection_;
    private boolean isTestWidget = false;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.isTestWidget = true;
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        parent.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWSM_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(this.pluginId_) + "." + this.INFOPOP_PWSM_PAGE);
        this.testCheckbox_ = uiUtils.createCheckbox(parent, ConsumptionUIMessages.BUTTON_TEST, ConsumptionUIMessages.TOOLTIP_PWSM_CHECKBOX_TEST, this.INFOPOP_PWSM_CHECKBOX_TEST);
        this.testCheckbox_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleTestButton();
            }
        });
        this.comboGroup_ = uiUtils.createComposite(parent, 3, 5, 0);
        this.testTypeCombo_ = uiUtils.createCombo(this.comboGroup_, ConsumptionUIMessages.LABEL_TEST_TYPES, ConsumptionUIMessages.TOOLTIP_PWSM_COMBOBOX_TEST, this.INFOPOP_PWSM_COMBOBOX_TEST, 2060);
        new Label(this.comboGroup_, 0);
        this.projectCombo_ = uiUtils.createCombo(this.comboGroup_, ConsumptionUIMessages.LABEL_JSP_PROJECT_NAME, ConsumptionUIMessages.TOOLTIP_PWSM_COMBO_PROJECT, this.INFOPOP_PWSM_COMBO_PROJECT, 2060);
        this.projectCombo_.setEnabled(false);
        new Label(this.comboGroup_, 0);
        this.earCombo_ = uiUtils.createCombo(this.comboGroup_, ConsumptionUIMessages.LABEL_EAR_PROJECTS, ConsumptionUIMessages.TOOLTIP_PWSM_EAR_PROJECT, this.INFOPOP_PWSM_EAR_COMBO, 2060);
        this.earCombo_.setEnabled(false);
        new Label(this.comboGroup_, 0);
        this.sampleFolderText_ = uiUtils.createText(this.comboGroup_, ConsumptionUIMessages.LABEL_FOLDER_NAME, ConsumptionUIMessages.TOOLTIP_PWSM_TEXT_SAMPLE_FOLDER, this.INFOPOP_PWSM_TEXT_SAMPLE_FOLDER, 2052);
        this.sampleFolderText_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ClientTestWidget.this.handleFolderText();
            }
        });
        this.sampleFolderBrowseButton_ = uiUtils.createPushButton(this.comboGroup_, ConsumptionUIMessages.BUTTON_BROWSE, ConsumptionUIMessages.TOOLTIP_PWSM_BUTTON_JSP_FOLDER_BROWSE, this.INFOPOP_PWSM_BUTTON_JSP_FOLDER_BROWSE);
        this.sampleFolderBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleSampleBrowse();
            }
        });
        this.jspFolderText_ = uiUtils.createText(this.comboGroup_, ConsumptionUIMessages.LABEL_JSP_FOLDER_NAME, ConsumptionUIMessages.TOOLTIP_PWSM_TEXT_JSP_FOLDER, this.INFOPOP_PWSM_TEXT_JSP_FOLDER, 2060);
        this.jspFolderText_.setEnabled(false);
        Group methodsGroup = uiUtils.createGroup(parent, ConsumptionUIMessages.LABEL_METHODS, ConsumptionUIMessages.TOOLTIP_PWSM_TREE_METHODS, null);
        methodsGroup.setLayoutData((Object)uiUtils.createFillAll());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        methodsGroup.setLayout((Layout)layout);
        this.methodsTree_ = uiUtils.createTree((Composite)methodsGroup, ConsumptionUIMessages.TOOLTIP_PWSM_TREE_METHODS, null, 2850);
        Composite selectButtons = uiUtils.createComposite((Composite)methodsGroup, 2);
        this.selectAllMethodsButton_ = uiUtils.createPushButton(selectButtons, ConsumptionUIMessages.BUTTON_SELECT_ALL, ConsumptionUIMessages.TOOLTIP_PWSM_BUTTON_SELECT_ALL, this.INFOPOP_PWSM_BUTTON_SELECT_ALL);
        this.selectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleSelectAll(true);
            }
        });
        this.deselectAllMethodsButton_ = uiUtils.createPushButton(selectButtons, ConsumptionUIMessages.BUTTON_DESELECT_ALL, ConsumptionUIMessages.TOOLTIP_PWSM_BUTTON_DESELECT_ALL, this.INFOPOP_PWSM_BUTTON_DESELECT_ALL);
        this.deselectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleSelectAll(false);
            }
        });
        this.runTestCheckbox_ = uiUtils.createCheckbox(parent, ConsumptionUIMessages.BUTTON_RUN_TEST, ConsumptionUIMessages.TOOLTIP_PWSM_CHECKBOX_LAUNCH, this.INFOPOP_PWSM_CHECKBOX_LAUNCH);
        return this;
    }

    private void handleFolderText() {
        String folder = this.sampleFolderText_.getText();
        String jspFolder = this.jspFolderText_.getText();
        int index = jspFolder.lastIndexOf(47);
        if (index == -1) {
            return;
        }
        jspFolder = jspFolder.substring(0, index + 1);
        jspFolder = String.valueOf(jspFolder) + folder;
        this.jspFolderText_.setText(jspFolder);
    }

    private void handleSampleBrowse() {
        IResource resource;
        IPath selectedPath = null;
        IResource initialResource = null;
        IPath projectPath = new Path(this.projectCombo_.getText()).makeAbsolute();
        IResource project = ResourceUtils.findResource((IPath)projectPath);
        IContainer webModuleContainer = J2EEUtils.getFirstWebContentContainer((IProject)((IProject)project));
        try {
            initialResource = ResourceUtils.getResourceFromSelection((Object)this.initialSelection_);
        }
        catch (CoreException coreException) {}
        if (initialResource == null) {
            initialResource = project;
        }
        if ((resource = DialogUtils.browseResources((Shell)this.comboGroup_.getShell(), (IResource)project, (IResource)initialResource, (Filter)this.folderFilter_)) != null) {
            selectedPath = resource.getFullPath();
            int webModuleSegments = selectedPath.matchingFirstSegments(webModuleContainer.getFullPath());
            if (webModuleSegments < 2) {
                this.sampleFolderText_.setText("");
                this.handleFolderText();
            } else {
                this.sampleFolderText_.setText(selectedPath.removeFirstSegments(webModuleSegments).toString());
                this.handleFolderText();
            }
        }
    }

    private void handleTestButton() {
        boolean enabled = this.testCheckbox_.getSelection();
        this.testTypeCombo_.setEnabled(enabled);
        this.sampleFolderText_.setEnabled(enabled);
        this.methodsTree_.setEnabled(enabled);
        this.runTestCheckbox_.setEnabled(enabled);
        this.selectAllMethodsButton_.setEnabled(enabled);
        this.deselectAllMethodsButton_.setEnabled(enabled);
        this.sampleFolderBrowseButton_.setEnabled(enabled);
    }

    private void handleSelectAll(boolean value) {
        TreeItem[] items = this.methodsTree_.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(value);
            ++i;
        }
    }

    public void setTestService(Boolean testService) {
        this.testCheckbox_.setSelection(testService.booleanValue());
        this.handleTestButton();
    }

    public Boolean getTestService() {
        return new Boolean(this.testCheckbox_.getSelection());
    }

    public void setTestFacility(SelectionList testFacilities) {
        this.testFacilities_ = testFacilities;
        this.testTypeCombo_.setItems(testFacilities.getList());
        this.testTypeCombo_.select(testFacilities.getIndex());
    }

    public SelectionList getTestFacility() {
        this.testFacilities_.setIndex(this.testTypeCombo_.getSelectionIndex());
        return this.testFacilities_;
    }

    public String getTestID() {
        return this.testTypeCombo_.getText();
    }

    public void setSampleProject(String clientProject) {
        this.projectCombo_.setItems(new String[]{clientProject});
        this.projectCombo_.select(0);
    }

    public void setSampleProjectEAR(String clientProjectEAR) {
        this.earCombo_.setItems(new String[]{clientProjectEAR});
        this.earCombo_.select(0);
    }

    public String getFolder() {
        return this.sampleFolderText_.getText();
    }

    public void setFolder(String folder) {
        this.sampleFolderText_.setText(folder);
    }

    public boolean getIsTestWidget() {
        return this.isTestWidget;
    }

    public void setJspFolder(String folder) {
        this.jspFolderText_.setText(folder);
    }

    public String getJspFolder() {
        return this.jspFolderText_.getText();
    }

    public void setLaunchedServiceTestName(String launchedServiceTestName) {
    }

    public boolean getRunTestClient() {
        return this.runTestCheckbox_.getSelection();
    }

    public void setRunTestClient(boolean value) {
        this.runTestCheckbox_.setSelection(value);
    }

    public BooleanSelection[] getMethods() {
        TreeItem[] items = this.methodsTree_.getItems();
        BooleanSelection[] methods = new BooleanSelection[items.length];
        int index = 0;
        while (index < items.length) {
            methods[index] = new BooleanSelection(items[index].getText(), items[index].getChecked());
            ++index;
        }
        return methods;
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methodsTree_.removeAll();
        int index = 0;
        while (index < methods.length) {
            if (methods[index] != null) {
                TreeItem item = new TreeItem(this.methodsTree_, 0);
                item.setText(methods[index].getValue());
                item.setChecked(methods[index].isSelected());
            }
            ++index;
        }
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection_ = selection;
    }
}

