/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.properties;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.jayasoft.ivyde.eclipse.IvyPlugin;

public class IvyProjectPropertyPage
extends PropertyPage {
    private static final String PATH_TITLE = "Ivy conf url:";
    private static final String ACCEPTED_TYPES_TITLE = "Accepted types:";
    private Text _pathValueText;
    private Button _retreiveB;
    private Text _patternT;
    private Text _acceptedTypesText;

    private void addMainSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        this._pathValueText = new Text(composite, 2052);
        String ivyconfURL = IvyPlugin.getStrictIvyconfURL(this.getJavaProject());
        if (ivyconfURL == null) {
            ivyconfURL = this.getDefaultIvyconfURLForDisplay();
        }
        this._pathValueText.setText(ivyconfURL);
        this._pathValueText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Button btn = new Button(composite, 0);
        btn.setText("Browse");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File f = IvyProjectPropertyPage.this.getFile(new File("/"));
                if (f != null) {
                    try {
                        IvyProjectPropertyPage.this._pathValueText.setText(f.toURL().toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
        });
        new Label(composite, 0);
        Label explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        explanation.setText("The url where your ivyconf file can be found. \nUse default to reference the default ivy configuration. \nUse [inherited] to use your general eclipse setting.");
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 1, false, false, 4, 1));
        Label acceptedTypesLabel = new Label(composite, 0);
        acceptedTypesLabel.setText(ACCEPTED_TYPES_TITLE);
        this._acceptedTypesText = new Text(composite, 2052);
        this._acceptedTypesText.setText(IvyPlugin.getAcceptedTypesString(this.getJavaProject()));
        this._acceptedTypesText.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        new Label(composite, 0);
        explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        explanation.setText("Comma separated list of artifact types to use in IvyDE Managed Dependencies Library.\nExample: jar, zip\nUse [inherited] to use your general eclise setting.");
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 1, false, false, 4, 1));
        this._retreiveB = new Button(composite, 32);
        this._retreiveB.setText("Do retrieve after resolve");
        this._retreiveB.setLayoutData((Object)new GridData(4, 1, false, false, 4, 1));
        new Label(composite, 0).setText("Pattern:");
        this._patternT = new Text(composite, 2052);
        this._patternT.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this._retreiveB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvyProjectPropertyPage.this._patternT.setEnabled(IvyProjectPropertyPage.this._retreiveB.getSelection());
            }
        });
        this._retreiveB.setSelection(IvyPlugin.shouldDoRetrieve(this.getJavaProject()));
        this._patternT.setEnabled(this._retreiveB.getSelection());
        this._patternT.setText(IvyPlugin.getRetrievePatternHerited(this.getJavaProject()));
        new Label(composite, 0);
        explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        explanation.setText("Example: lib/[conf]/[artifact].[ext]\nTo copy artifacts in folder named lib without revision by folder named like configurations\nUse [inherited] to use your general eclipse setting.");
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 1, false, false, 4, 1));
    }

    private IJavaProject getJavaProject() {
        IAdaptable adaptable = this.getElement();
        IJavaProject project = null;
        if (adaptable instanceof IJavaProject) {
            project = (IJavaProject)adaptable;
        } else if (adaptable instanceof IProject) {
            project = JavaCore.create((IProject)((IProject)adaptable));
        } else {
            throw new IllegalStateException("Attempting a IProject element ! Not " + adaptable.getClass().getName() + " element");
        }
        return project;
    }

    private File getFile(File startingDirectory) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        String file = dialog.open();
        if (file != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addMainSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this._pathValueText.setText(this.getDefaultIvyconfURLForDisplay());
        this._retreiveB.setSelection(false);
        this._patternT.setText("");
        this._acceptedTypesText.setText("[inherited]");
    }

    private String getDefaultIvyconfURLForDisplay() {
        return "[inherited] " + IvyPlugin.getIvyconfURL();
    }

    public boolean performOk() {
        IvyPlugin.beginChanges();
        try {
            String text = this._pathValueText.getText();
            if (text.startsWith("[inherited] ") || text.trim().length() == 0) {
                text = null;
            }
            IvyPlugin.setIvyconfURL(this.getJavaProject(), text);
            if (this._retreiveB.getSelection()) {
                IvyPlugin.setRetreivePattern(this.getJavaProject(), this._patternT.getText());
            } else {
                IvyPlugin.setRetreivePattern(this.getJavaProject(), "");
            }
            IvyPlugin.setAcceptedTypes(this.getJavaProject(), this._acceptedTypesText.getText());
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IvyPlugin.commitChanges();
            throw throwable;
        }
        IvyPlugin.commitChanges();
        return true;
    }
}

