/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.cpcontainer;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.event.IvyListener;
import fr.jayasoft.ivy.event.download.EndArtifactDownloadEvent;
import fr.jayasoft.ivy.event.download.PrepareDownloadEvent;
import fr.jayasoft.ivy.event.download.StartArtifactDownloadEvent;
import fr.jayasoft.ivy.event.resolve.EndResolveDependencyEvent;
import fr.jayasoft.ivy.event.resolve.StartResolveDependencyEvent;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import fr.jayasoft.ivy.repository.TransferEvent;
import fr.jayasoft.ivy.repository.TransferListener;
import fr.jayasoft.ivy.xml.XmlReportParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.swt.widgets.Display;
import org.jayasoft.ivyde.eclipse.IvyPlugin;

public class IvyClasspathContainer
implements IClasspathContainer {
    public static final String IVY_CLASSPATH_CONTAINER_ID = "org.jayasoft.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER";
    private IClasspathEntry[] _classpathEntries;
    private IJavaProject _javaProject;
    private File _ivyXmlFile;
    private String _ivyXmlPath;
    private String[] _confs = new String[]{"default"};
    private IPath _path;
    private IvyResolveJob _job;
    private static final ISchedulingRule RESOLVE_EVENT_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public IvyClasspathContainer(IJavaProject javaProject, IPath path, String ivyFile, String[] confs) {
        this._javaProject = javaProject;
        this._path = path;
        this._ivyXmlPath = ivyFile;
        this._ivyXmlFile = this.resolveFile(ivyFile);
        this._confs = confs;
        this.computeClasspathEntries(true, false).run((IProgressMonitor)new NullProgressMonitor());
        if (this._classpathEntries == null) {
            this._classpathEntries = new IClasspathEntry[0];
        }
        IvyPlugin.getDefault().register(this);
    }

    private File resolveFile(String path) {
        IFile iFile = this._javaProject.getProject().getFile(path);
        return new File(iFile.getLocation().toOSString());
    }

    public String getDescription() {
        return String.valueOf(this._ivyXmlPath) + " " + Arrays.asList(this._confs);
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this._path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this._classpathEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IvyResolveJob computeClasspathEntries(boolean usePreviousResolveIfExist, boolean notify) {
        try {
            Ivy ivy = IvyPlugin.getIvy(this._javaProject);
            IvyClasspathContainer ivyClasspathContainer = this;
            synchronized (ivyClasspathContainer) {
                if (this._job != null) {
                    return this._job;
                }
                this._job = new IvyResolveJob(ivy, usePreviousResolveIfExist, notify);
                this._job.setUser(true);
                this._job.setRule(RESOLVE_EVENT_RULE);
                return this._job;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void resolve() {
        this.computeClasspathEntries(false, true).schedule();
    }

    public void refresh() {
        this.computeClasspathEntries(true, true).schedule();
    }

    private void updateClasspathEntries(boolean usePreviousResolveIfExist, boolean notify, File[] jarFiles) {
        if (jarFiles != null) {
            IClasspathEntry[] entries = new IClasspathEntry[jarFiles.length];
            int i = 0;
            while (i < jarFiles.length) {
                Path path = new Path(jarFiles[i].getAbsolutePath());
                entries[i] = JavaCore.newLibraryEntry((IPath)path, (IPath)IvyPlugin.getDefault().getPackageFragmentExtraInfo().getSourceAttachment(path), (IPath)IvyPlugin.getDefault().getPackageFragmentExtraInfo().getSourceAttachmentRoot(path), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])this.getExtraAttribute(path), (boolean)false);
                ++i;
            }
            this.setClasspathEntries(entries);
        } else {
            this.setClasspathEntries(new IClasspathEntry[0]);
        }
        if (notify) {
            this.notifyUpdateClasspathEntries();
        }
    }

    private IClasspathAttribute[] getExtraAttribute(Path path) {
        ArrayList<ClasspathAttribute> result = new ArrayList<ClasspathAttribute>();
        IPath p = IvyPlugin.getDefault().getPackageFragmentExtraInfo().getDocAttachment(path);
        if (p != null) {
            result.add(new ClasspathAttribute("javadoc_location", p.toPortableString()));
        }
        return result.toArray(new IClasspathAttribute[result.size()]);
    }

    private void setClasspathEntries(final IClasspathEntry[] entries) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IvyClasspathContainer.this._classpathEntries = entries;
            }
        });
    }

    private void notifyUpdateClasspathEntries() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    JavaModelManager manager = JavaModelManager.getJavaModelManager();
                    manager.containerPut(IvyClasspathContainer.this._javaProject, IvyClasspathContainer.this._path, null);
                    JavaCore.setClasspathContainer((IPath)IvyClasspathContainer.this._path, (IJavaProject[])new IJavaProject[]{IvyClasspathContainer.this._javaProject}, (IClasspathContainer[])new IClasspathContainer[]{IvyClasspathContainer.this}, null);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static String[] getConfigurations(IPath containerPath) {
        return containerPath.lastSegment().split(",");
    }

    public static String getConfigurationsText(IPath containerPath) {
        return containerPath.lastSegment();
    }

    public static String getIvyFilePath(IPath containerPath) {
        return ((IPath)containerPath.clone()).removeFirstSegments(1).removeLastSegments(1).toString();
    }

    public static boolean isIvyClasspathContainer(IPath containerPath) {
        return containerPath.segmentCount() >= 3 && IVY_CLASSPATH_CONTAINER_ID.equals(containerPath.segment(0));
    }

    public static void resolveIfNeeded(IFile file) {
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathContainer cp;
                IPath path;
                IClasspathEntry entry = entries[i];
                if (entry != null && entry.getEntryKind() == 5 && IvyClasspathContainer.isIvyClasspathContainer(path = entry.getPath()) && file.getProjectRelativePath().toString().equals(IvyClasspathContainer.getIvyFilePath(path)) && (cp = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject)) instanceof IvyClasspathContainer) {
                    IvyClasspathContainer c = (IvyClasspathContainer)cp;
                    c.resolve();
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static void resolve(IJavaProject javaProject) {
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathContainer cp;
                IPath path;
                IClasspathEntry entry = entries[i];
                if (entry != null && entry.getEntryKind() == 5 && IvyClasspathContainer.isIvyClasspathContainer(path = entry.getPath()) && (cp = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject)) instanceof IvyClasspathContainer) {
                    IvyClasspathContainer c = (IvyClasspathContainer)cp;
                    c.resolve();
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public IFile getIvyFile() {
        return this._javaProject.getProject().getFile(this._ivyXmlPath);
    }

    public URL getReportUrl() {
        try {
            Ivy ivy = IvyPlugin.getIvy(this._javaProject);
            URL ivyURL = this._ivyXmlFile.toURL();
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(ivy, ivyURL, false);
            return new File(ivy.getDefaultCache(), XmlReportOutputter.getReportFileName((ModuleId)md.getModuleRevisionId().getModuleId(), (String)md.getConfigurationsNames()[0])).toURL();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IJavaProject getProject() {
        return this._javaProject;
    }

    static /* synthetic */ File access$2(IvyClasspathContainer ivyClasspathContainer) {
        return ivyClasspathContainer._ivyXmlFile;
    }

    static /* synthetic */ String[] access$3(IvyClasspathContainer ivyClasspathContainer) {
        return ivyClasspathContainer._confs;
    }

    static /* synthetic */ void access$4(IvyClasspathContainer ivyClasspathContainer, IvyResolveJob ivyResolveJob) {
        ivyClasspathContainer._job = ivyResolveJob;
    }

    static /* synthetic */ void access$5(IvyClasspathContainer ivyClasspathContainer, boolean bl, boolean bl2, File[] fileArray) {
        ivyClasspathContainer.updateClasspathEntries(bl, bl2, fileArray);
    }

    private final class IvyResolveJob
    extends Job
    implements TransferListener,
    IvyListener {
        long _expectedTotalLength = 1L;
        long _currentLength = 0L;
        private IProgressMonitor _monitor;
        private IProgressMonitor _dlmonitor;
        private Ivy _ivy;
        private boolean _usePreviousResolveIfExist;
        private int _workPerArtifact = 100;
        private boolean _notify;
        static /* synthetic */ Class class$0;

        public IvyResolveJob(Ivy ivy, boolean usePreviousResolveIfExist, boolean notify) {
            super("Resolve " + IvyClasspathContainer.this._javaProject.getProject().getName() + "/" + IvyClasspathContainer.this._ivyXmlPath + " dependencies");
            this._ivy = ivy;
            this._usePreviousResolveIfExist = usePreviousResolveIfExist;
            this._notify = notify;
        }

        public void transferProgress(TransferEvent evt) {
            switch (evt.getEventType()) {
                case 0: {
                    this._monitor.setTaskName("downloading " + evt.getResource());
                    break;
                }
                case 1: {
                    this._currentLength = 0L;
                    if (!evt.isTotalLengthSet()) break;
                    this._expectedTotalLength = evt.getTotalLength();
                    this._dlmonitor.beginTask("downloading " + evt.getResource(), 100);
                    break;
                }
                case 3: {
                    if (this._expectedTotalLength <= 1L) break;
                    this._currentLength += evt.getLength();
                    this._dlmonitor.worked((int)(this._currentLength * 100L / this._expectedTotalLength));
                    this._monitor.subTask(String.valueOf(this._currentLength / 1024L) + " / " + this._expectedTotalLength / 1024L + "kB");
                }
            }
        }

        public void progress(IvyEvent event) {
            if (event instanceof TransferEvent) {
                if (this._dlmonitor != null) {
                    this.transferProgress((TransferEvent)event);
                }
            } else if (event instanceof PrepareDownloadEvent) {
                PrepareDownloadEvent pde = (PrepareDownloadEvent)event;
                Artifact[] artifacts = pde.getArtifacts();
                if (artifacts.length > 0) {
                    this._workPerArtifact = 1000 / artifacts.length;
                }
            } else if (event instanceof StartArtifactDownloadEvent) {
                StartArtifactDownloadEvent evt = (StartArtifactDownloadEvent)event;
                this._monitor.setTaskName("downloading " + evt.getArtifact());
                if (this._dlmonitor != null) {
                    this._dlmonitor.done();
                }
                this._dlmonitor = new SubProgressMonitor(this._monitor, this._workPerArtifact);
            } else if (event instanceof EndArtifactDownloadEvent) {
                if (this._dlmonitor != null) {
                    this._dlmonitor.done();
                }
                this._monitor.subTask(" ");
                this._dlmonitor = null;
            } else if (event instanceof StartResolveDependencyEvent) {
                StartResolveDependencyEvent ev = (StartResolveDependencyEvent)event;
                this._monitor.subTask("resolving " + ev.getDependencyDescriptor().getDependencyRevisionId());
            } else if (event instanceof EndResolveDependencyEvent) {
                this._monitor.subTask(" ");
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private File[] parseResolvedConfs(String[] confs, ModuleId mid) throws ParseException, IOException {
            XmlReportParser parser = new XmlReportParser();
            LinkedHashSet<Artifact> all = new LinkedHashSet<Artifact>();
            int i = 0;
            while (i < confs.length) {
                Artifact[] artifacts = parser.getArtifacts(mid, confs[i], this._ivy.getDefaultCache());
                all.addAll(Arrays.asList(artifacts));
                ++i;
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (!IvyPlugin.accept(IvyClasspathContainer.this._javaProject, artifact)) continue;
                files.add(this._ivy.getArchiveFileInCache(this._ivy.getDefaultCache(), artifact));
            }
            File[] jarFiles = files.toArray(new File[files.size()]);
            return jarFiles;
        }

        static /* synthetic */ Ivy access$0(IvyResolveJob ivyResolveJob) {
            return ivyResolveJob._ivy;
        }

        static /* synthetic */ IProgressMonitor access$1(IvyResolveJob ivyResolveJob) {
            return ivyResolveJob._monitor;
        }

        static /* synthetic */ boolean access$2(IvyResolveJob ivyResolveJob) {
            return ivyResolveJob._usePreviousResolveIfExist;
        }

        static /* synthetic */ File[] access$3(IvyResolveJob ivyResolveJob, String[] stringArray, ModuleId moduleId) throws ParseException, IOException {
            return ivyResolveJob.parseResolvedConfs(stringArray, moduleId);
        }

        static /* synthetic */ IvyClasspathContainer access$4(IvyResolveJob ivyResolveJob) {
            return ivyResolveJob.IvyClasspathContainer.this;
        }
    }
}

