/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class ExtendedPreferences
implements Cloneable {
    public static final String EFFORT_MIN = "min";
    public static final String EFFORT_DEFAULT = "default";
    public static final String EFFORT_MAX = "max";
    private static final String EFFORT_KEY = "effort";
    private static final String INCLUDE_FILTER_KEY = "includefilter";
    private static final String EXCLUDE_FILTER_KEY = "excludefilter";
    private String effort = "default";
    private String[] includeFilterFiles = new String[0];
    private String[] excludeFilterFiles = new String[0];

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        if (!(EFFORT_MIN.equals(effort) || EFFORT_DEFAULT.equals(effort) || EFFORT_MAX.equals(effort))) {
            throw new IllegalArgumentException("Effort \"" + effort + "\" is not a valid effort value.");
        }
        this.effort = effort;
    }

    public String[] getIncludeFilterFiles() {
        return this.includeFilterFiles;
    }

    public void setIncludeFilterFiles(String[] includeFilterFiles) {
        if (includeFilterFiles == null) {
            throw new IllegalArgumentException("includeFilterFiles may not be null.");
        }
        this.includeFilterFiles = includeFilterFiles;
    }

    public void setExcludeFilterFiles(String[] excludeFilterFiles) {
        if (excludeFilterFiles == null) {
            throw new IllegalArgumentException("excludeFilterFiles may not be null.");
        }
        this.excludeFilterFiles = excludeFilterFiles;
    }

    public String[] getExcludeFilterFiles() {
        return this.excludeFilterFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File \"" + file.getAbsolutePath() + "\" should exist and must be a file.");
        }
        Properties props = new Properties();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            props.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        this.effort = props.getProperty(EFFORT_KEY, EFFORT_DEFAULT);
        this.includeFilterFiles = this.readFilters(props, INCLUDE_FILTER_KEY);
        this.excludeFilterFiles = this.readFilters(props, EXCLUDE_FILTER_KEY);
    }

    private String[] readFilters(Properties props, String keyPrefix) {
        ArrayList<String> filters = new ArrayList<String>();
        int counter = 0;
        boolean keyFound = true;
        while (keyFound) {
            String property = props.getProperty(keyPrefix + counter);
            if (property != null) {
                filters.add(property);
                ++counter;
                continue;
            }
            keyFound = false;
        }
        return filters.toArray(new String[filters.size()]);
    }

    private void writeFilters(Properties props, String keyPrefix, String[] filters) {
        int counter;
        for (counter = 0; counter < filters.length; ++counter) {
            props.setProperty(keyPrefix + counter, filters[counter]);
        }
        boolean keyFound = true;
        while (keyFound) {
            String key = keyPrefix + counter;
            String property = props.getProperty(key);
            if (property == null) {
                keyFound = false;
                continue;
            }
            props.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File \"" + file.getAbsolutePath() + "\" should exist and must be a file.");
        }
        Properties props = new Properties();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            props.load(inputStream);
            props.setProperty(EFFORT_KEY, this.effort);
            this.writeFilters(props, INCLUDE_FILTER_KEY, this.includeFilterFiles);
            this.writeFilters(props, EXCLUDE_FILTER_KEY, this.excludeFilterFiles);
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                props.store(outputStream, "FindBugs User Preferences");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        this.effort = props.getProperty(EFFORT_KEY, EFFORT_DEFAULT);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.effort.hashCode() + TigerSubstitutes.hashCode((Object[])this.includeFilterFiles) + TigerSubstitutes.hashCode((Object[])this.excludeFilterFiles);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ExtendedPreferences) {
            ExtendedPreferences other = (ExtendedPreferences)obj;
            return this.effort.equals(other.effort) && Arrays.equals(this.includeFilterFiles, other.includeFilterFiles) && Arrays.equals(this.excludeFilterFiles, other.excludeFilterFiles);
        }
        return false;
    }

    public AnalysisFeatureSetting[] getAnalysisFeatureSettings() {
        if (this.effort.equals(EFFORT_DEFAULT)) {
            return FindBugs.DEFAULT_EFFORT;
        }
        if (this.effort.equals(EFFORT_MIN)) {
            return FindBugs.MIN_EFFORT;
        }
        return FindBugs.MAX_EFFORT;
    }
}

