/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class DetailsView
extends ViewPart {
    private static DetailsView detailsView;
    private String description = "";
    private String title = "";
    private List annotationList;
    @CheckForNull
    private StyledText control;
    private DefaultInformationControl.IInformationPresenter presenter;
    private TextPresentation presentation = new TextPresentation();
    @CheckForNull
    private Browser browser;

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 512);
        this.annotationList = new List((Composite)sash, 512);
        try {
            this.browser = new Browser((Composite)sash, 0);
        }
        catch (SWTError e) {
            this.control = new StyledText((Composite)sash, 776);
            this.control.setEditable(false);
            this.control.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DetailsView.this.updateDisplay();
                }
            });
            this.presenter = new HTMLTextPresenter(false);
        }
        detailsView = this;
    }

    public void setFocus() {
        this.annotationList.setFocus();
    }

    public void dispose() {
        this.annotationList.dispose();
        if (this.browser != null) {
            this.browser.dispose();
        } else if (this.control != null) {
            this.control.dispose();
        }
    }

    private void updateDisplay() {
        String html = "<b>" + this.title + "</b><br/>" + this.description;
        this.setHTMLText(html);
    }

    private void setHTMLText(String html) {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setText(html);
        } else {
            StyledText control = this.control;
            if (control != null && !control.isDisposed()) {
                Rectangle size = this.control.getClientArea();
                html = this.presenter.updatePresentation(this.getSite().getShell().getDisplay(), html, this.presentation, size.width, size.height);
                control.setText(html);
                TextPresentation.applyTextPresentation((TextPresentation)this.presentation, (StyledText)control);
            }
        }
    }

    public void setContent(String title, String description) {
        this.title = title == null ? "" : title.trim();
        this.description = description == null ? "" : description.trim();
        this.updateDisplay();
    }

    public static void showMarker(IMarker marker) {
        IWorkbenchPage[] pages = FindbugsPlugin.getActiveWorkbenchWindow().getPages();
        if (pages.length > 0) {
            try {
                pages[0].showView("de.tobject.findbugs.view.detailsview");
                String bugType = marker.getAttribute("BUGTYPE", "");
                DetectorFactoryCollection.instance().ensureLoaded();
                BugPattern pattern = I18N.instance().lookupBugPattern(bugType);
                if (pattern != null) {
                    String shortDescription = pattern.getShortDescription();
                    String detailText = pattern.getDetailText();
                    DetailsView.getDetailsView().setContent(shortDescription, detailText);
                }
                List anList = DetailsView.getDetailsView().annotationList;
                anList.removeAll();
                BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
                if (bug != null) {
                    Iterator it = bug.annotationIterator();
                    while (it.hasNext()) {
                        BugAnnotation ba = (BugAnnotation)it.next();
                        anList.add(ba.toString());
                    }
                }
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not update bug details view");
            }
        }
    }

    public static DetailsView getDetailsView() {
        return detailsView;
    }

    public static void setDetailsView(DetailsView view) {
        detailsView = view;
    }
}

