/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.plugin.eclipse.ExtendedPreferences;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsWorker {
    private static final boolean INCREMENTAL_UPDATE = false;
    public static boolean DEBUG;
    private IProgressMonitor monitor;
    private UserPreferences userPrefs;
    private ExtendedPreferences extendedPrefs;
    private IProject project;

    public FindBugsWorker(IProject project, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        try {
            this.userPrefs = FindbugsPlugin.getUserPreferences(project);
            this.extendedPrefs = FindbugsPlugin.getExtendedPreferences(project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not get selected detectors for project");
        }
    }

    public void work(Collection files) throws CoreException {
        if (files == null) {
            FindbugsPlugin.getDefault().logError("No files to build");
            return;
        }
        String findBugsHome = FindbugsPlugin.getFindBugsEnginePluginLocation();
        if (DEBUG) {
            FindbugsPlugin.getDefault().logInfo(new StringBuffer().append("Looking for detectors in: ").append(findBugsHome).toString());
        }
        System.setProperty("findbugs.home", findBugsHome);
        Set<IPath> outLocations = this.createOutputLocations();
        Project findBugsProject = new Project();
        for (IResource res : files) {
            if (res == null) continue;
            if (Util.isJavaArtifact(res)) {
                res.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
            }
            IPath location = res.getLocation();
            if (!Util.isClassFile(res) || !this.containsIn(outLocations, location)) continue;
            String fileName = location.toOSString();
            res.refreshLocal(2, null);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Resource: ").append(fileName).append(": in sync: ").append(res.isSynchronized(2)).toString());
            }
            findBugsProject.addFile(fileName);
        }
        Reporter bugReporter = new Reporter(this.project, this.monitor, findBugsProject);
        bugReporter.setPriorityThreshold(3);
        String[] classPathEntries = this.createClassPathEntries();
        for (int i = 0; i < classPathEntries.length; ++i) {
            findBugsProject.addAuxClasspathEntry(classPathEntries[i]);
        }
        FindBugs2 engine = new FindBugs2();
        engine.setBugReporter((BugReporter)bugReporter);
        engine.setProject(findBugsProject);
        engine.setProgressCallback((FindBugsProgress)bugReporter);
        engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        FindBugs2 findBugs = engine;
        findBugs.setUserPreferences(this.userPrefs);
        this.configureExtended((IFindBugsEngine)findBugs);
        try {
            findBugs.execute();
            this.updateBugCollection(findBugsProject, bugReporter);
        }
        catch (InterruptedException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs analysis");
        }
    }

    private void updateBugCollection(Project findBugsProject, Reporter bugReporter) throws CoreException, IOException, DocumentException {
        SortedBugCollection oldBugCollection = FindbugsPlugin.getBugCollection(this.project, this.monitor);
        SortedBugCollection newBugCollection = bugReporter.getBugCollection();
        this.updateBugCollectionDestructively(bugReporter, oldBugCollection, newBugCollection);
        FindbugsPlugin.storeBugCollection(this.project, oldBugCollection, findBugsProject, this.monitor);
    }

    private void updateBugCollectionIncrementally(Reporter bugReporter, SortedBugCollection oldBugCollection, SortedBugCollection newBugCollection) {
        throw new UnsupportedOperationException();
    }

    private void updateBugCollectionDestructively(Reporter bugReporter, SortedBugCollection oldBugCollection, SortedBugCollection newBugCollection) {
        ArrayList<BugInstance> toRemove = new ArrayList<BugInstance>();
        if (oldBugCollection != null) {
            Set<String> analyzedClassNameSet = bugReporter.getAnalyzedClassNames();
            for (BugInstance oldWarning : oldBugCollection) {
                ClassAnnotation warningClass = oldWarning.getPrimaryClass();
                if (warningClass == null || !analyzedClassNameSet.contains(warningClass.getClassName())) continue;
                toRemove.add(oldWarning);
            }
            for (BugInstance removeMe : toRemove) {
                oldBugCollection.remove(removeMe);
            }
        } else {
            oldBugCollection = new SortedBugCollection();
        }
        for (BugInstance newWarning : newBugCollection) {
            oldBugCollection.add(newWarning);
        }
    }

    private void configureExtended(IFindBugsEngine findBugs) {
        findBugs.setAnalysisFeatureSettings(this.extendedPrefs.getAnalysisFeatureSettings());
        String[] includeFilterFiles = this.extendedPrefs.getIncludeFilterFiles();
        for (int i = 0; i < includeFilterFiles.length; ++i) {
            IFile file = this.project.getFile(includeFilterFiles[i]);
            if (!file.exists()) continue;
            String filterName = file.getLocation().toOSString();
            try {
                findBugs.addFilter(filterName, true);
                continue;
            }
            catch (FilterException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), new StringBuffer().append("Error while loading filter \"").append(filterName).append("\".").toString());
                continue;
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, new StringBuffer().append("Error while reading filter \"").append(filterName).append("\".").toString());
            }
        }
        String[] excludeFilterFiles = this.extendedPrefs.getExcludeFilterFiles();
        for (int i = 0; i < excludeFilterFiles.length; ++i) {
            IFile file = this.project.getFile(excludeFilterFiles[i]);
            if (!file.exists()) continue;
            String filterName = file.getLocation().toOSString();
            try {
                findBugs.addFilter(filterName, false);
                continue;
            }
            catch (FilterException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), new StringBuffer().append("Error while loading filter \"").append(filterName).append("\".").toString());
                continue;
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, new StringBuffer().append("Error while reading filter \"").append(filterName).append("\".").toString());
            }
        }
    }

    private String[] createClassPathEntries() {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        catch (CoreException e) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not compute classpath for project");
            }
            return new String[0];
        }
    }

    private Set<IPath> createOutputLocations() throws CoreException {
        IPath def;
        HashSet<IPath> set = new HashSet<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IPath projectLocation = javaProject.getProject().getLocation();
        if (javaProject.exists() && javaProject.getProject().isOpen()) {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            for (int i = 0; i < entries.length; ++i) {
                IPath path;
                IClasspathEntry classpathEntry = entries[i];
                if (classpathEntry.getEntryKind() != 3 || (path = classpathEntry.getOutputLocation()) == null) continue;
                if (path.segmentCount() > 0) {
                    path = path.removeFirstSegments(1);
                }
                set.add(projectLocation.append(path));
            }
        }
        if ((def = javaProject.getOutputLocation()).segmentCount() > 0) {
            def = def.removeFirstSegments(1);
        }
        if (!set.contains(def = projectLocation.append(def))) {
            set.add(def);
        }
        return set;
    }

    private boolean containsIn(Set<IPath> outputLocations, IPath path) {
        for (IPath dir : outputLocations) {
            if (!dir.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }
}

