/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsSaveParticipant;
import de.tobject.findbugs.builder.AbstractFilesCollector;
import de.tobject.findbugs.builder.FilesCollectorFactory;
import de.tobject.findbugs.builder.FindBugsBuilder;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.io.FileOutput;
import de.tobject.findbugs.io.IO;
import de.tobject.findbugs.nature.FindBugsNature;
import de.tobject.findbugs.reporter.Reporter;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.ExtendedPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionAssociations;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FindbugsPlugin
extends AbstractUIPlugin {
    public static boolean DEBUG;
    public static final String PLUGIN_ID = "edu.umd.cs.findbugs.plugin.eclipse";
    public static final String BUILDER_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder";
    public static final String NATURE_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature";
    private static final String PLUGIN_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/plugin";
    private static final String WORKER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/worker";
    private static final String BUILDER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/builder";
    private static final String MARKER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/marker";
    private static final String NATURE_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/nature";
    private static final String PROPERTIES_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/properties";
    private static final String REPORTER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/reporter";
    private static final String UTIL_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/util";
    private static final String VISITOR_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/visitor";
    public static final QualifiedName PERSISTENT_PROPERTY_ACTIVE_DETECTORS;
    public static final QualifiedName SESSION_PROPERTY_ACTIVE_DETECTORS;
    public static final QualifiedName PERSISTENT_PROPERTY_FILTER_SETTINGS;
    public static final QualifiedName SESSION_PROPERTY_FILTER_SETTINGS;
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION;
    public static final QualifiedName SESSION_PROPERTY_FB_PROJECT;
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION_DIRTY;
    public static final QualifiedName SESSION_PROPERTY_USERPREFS;
    public static final QualifiedName SESSION_PROPERTY_EXTENDEDPREFS;
    public static final String LIST_DELIMITER = ";";
    private static FindbugsPlugin plugin;
    private ResourceBundle resourceBundle;
    private BugResolutionAssociations bugResolutions;

    public FindbugsPlugin() {
        plugin = this;
        this.configurePluginDebugOptions();
        try {
            this.resourceBundle = ResourceBundle.getBundle("de.tobject.findbugs.messages");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        String findBugsHome = FindbugsPlugin.getFindBugsEnginePluginLocation();
        if (DEBUG) {
            this.logInfo("Looking for FindBugs detectors in: " + findBugsHome);
        }
        System.setProperty("findbugs.home", findBugsHome);
        FindbugsSaveParticipant saveParticipant = new FindbugsSaveParticipant();
        ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)saveParticipant);
    }

    public static FindbugsPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbench getActiveWorkbench() {
        FindbugsPlugin plugin = FindbugsPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getWorkbench();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = FindbugsPlugin.getActiveWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = FindbugsPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = FindbugsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void configurePluginDebugOptions() {
        if (this.isDebugging()) {
            String option = Platform.getDebugOption((String)PLUGIN_DEBUG);
            if (option != null) {
                DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)BUILDER_DEBUG)) != null) {
                AbstractFilesCollector.DEBUG = FindBugsBuilder.DEBUG = option.equalsIgnoreCase("true");
                FilesCollectorFactory.DEBUG = FindBugsBuilder.DEBUG;
                FindBugsWorker.DEBUG = FindBugsBuilder.DEBUG;
            }
            if ((option = Platform.getDebugOption((String)NATURE_DEBUG)) != null) {
                FindBugsNature.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)REPORTER_DEBUG)) != null) {
                Reporter.DEBUG = option.equalsIgnoreCase("true");
            }
        }
    }

    public static String getFindBugsEnginePluginLocation() {
        URL u = plugin.find((IPath)new Path("."));
        try {
            URL u2 = Platform.resolve((URL)u);
            String pluginPath = u2.getPath();
            if (FindBugsBuilder.DEBUG) {
                System.out.println("Pluginpath: " + pluginPath);
            }
            return pluginPath;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (FindBugsBuilder.DEBUG) {
            System.out.println("Could not find findbugs binaries.");
        }
        return null;
    }

    public String getMessage(String key) {
        return FindbugsPlugin.getResourceString(key);
    }

    public void logException(Exception e, String message) {
        this.logMessage(4, message, e);
    }

    public void logError(String message) {
        this.logMessage(4, message, null);
    }

    public void logWarning(String message) {
        this.logMessage(2, message, null);
    }

    public void logInfo(String message) {
        this.logMessage(1, message, null);
    }

    public void logMessage(int severity, String message, Exception e) {
        if (DEBUG) {
            String what = severity == 4 ? (e != null ? "Exception" : "Error") : "Warning";
            System.err.println(what + " in FindBugs plugin: " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        Status status = new Status(severity, PLUGIN_ID, 0, message, (Throwable)e);
        this.getLog().log((IStatus)status);
    }

    private static ProjectFilterSettings getProjectFilterSettings(IProject project) throws CoreException {
        ProjectFilterSettings settings = (ProjectFilterSettings)project.getSessionProperty(SESSION_PROPERTY_FILTER_SETTINGS);
        if (settings == null) {
            String savedSettings = project.getPersistentProperty(PERSISTENT_PROPERTY_FILTER_SETTINGS);
            if (savedSettings == null) {
                settings = ProjectFilterSettings.createDefault();
                project.setPersistentProperty(PERSISTENT_PROPERTY_FILTER_SETTINGS, settings.toEncodedString());
            } else {
                settings = ProjectFilterSettings.fromEncodedString((String)savedSettings);
            }
            project.setSessionProperty(SESSION_PROPERTY_FILTER_SETTINGS, (Object)settings);
        }
        return settings;
    }

    private static IPath getBugCollectionFile(IProject project) {
        IPath path = FindbugsPlugin.getDefault().getStateLocation();
        return path.append(project.getName() + ".fbwarnings");
    }

    public static boolean isBugCollectionDirty(IProject project) throws CoreException {
        Object dirty = project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY);
        if (dirty == null) {
            return false;
        }
        return (Boolean)dirty;
    }

    public static void markBugCollectionDirty(IProject project, boolean isDirty) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY, (Object)(isDirty ? Boolean.TRUE : Boolean.FALSE));
    }

    public static SortedBugCollection getBugCollection(IProject project, IProgressMonitor monitor) throws CoreException {
        SortedBugCollection bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
        if (bugCollection == null) {
            try {
                FindbugsPlugin.readBugCollectionAndProject(project, monitor);
                bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
            catch (DocumentException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
        }
        return bugCollection;
    }

    private static void cacheBugCollectionAndProject(IProject project, SortedBugCollection bugCollection, Project fbProject) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        project.setSessionProperty(SESSION_PROPERTY_FB_PROJECT, (Object)fbProject);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static SortedBugCollection createDefaultEmptyBugCollection(IProject project) throws CoreException {
        SortedBugCollection bugCollection = new SortedBugCollection();
        Project fbProject = new Project();
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, fbProject);
        return bugCollection;
    }

    private static void readBugCollectionAndProject(IProject project, IProgressMonitor monitor) throws IOException, DocumentException, CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        if (!bugCollectionFile.exists()) {
            FindbugsPlugin.getDefault().logInfo("creating new bug collection: " + bugCollectionPath.toOSString());
            FindbugsPlugin.createDefaultEmptyBugCollection(project);
            return;
        }
        SortedBugCollection bugCollection = new SortedBugCollection();
        Project findbugsProject = new Project();
        BufferedInputStream contents = new BufferedInputStream(new FileInputStream(bugCollectionFile));
        bugCollection.readXML((InputStream)contents, findbugsProject);
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, findbugsProject);
    }

    public static void storeBugCollection(IProject project, SortedBugCollection bugCollection, Project findbugsProject, IProgressMonitor monitor) throws IOException, CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        project.setSessionProperty(SESSION_PROPERTY_FB_PROJECT, (Object)findbugsProject);
        if (bugCollection != null && findbugsProject != null) {
            FindbugsPlugin.writeBugCollection(project, bugCollection, findbugsProject, monitor);
        }
    }

    public static void saveCurrentBugCollection(IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        if (FindbugsPlugin.isBugCollectionDirty(project)) {
            SortedBugCollection bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
            Project fbProject = (Project)project.getSessionProperty(SESSION_PROPERTY_FB_PROJECT);
            if (bugCollection != null && fbProject != null) {
                FindbugsPlugin.writeBugCollection(project, bugCollection, fbProject, monitor);
            }
        }
    }

    private static void writeBugCollection(IProject project, final SortedBugCollection bugCollection, final Project findbugsProject, IProgressMonitor monitor) throws IOException, CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        FileOutput fileOutput = new FileOutput(){

            public void writeFile(OutputStream os) throws IOException {
                bugCollection.writeXML(os, findbugsProject);
            }

            public String getTaskDescription() {
                return "creating XML FindBugs data file";
            }
        };
        IO.writeFile(bugCollectionFile, fileOutput, monitor);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    public static IFile getUserPreferencesFile(IProject project) {
        return project.getFile(".fbprefs");
    }

    public static UserPreferences getUserPreferences(IProject project) throws CoreException {
        UserPreferences prefs = (UserPreferences)project.getSessionProperty(SESSION_PROPERTY_USERPREFS);
        if (prefs == null) {
            prefs = FindbugsPlugin.readUserPreferences(project);
            if (prefs == null) {
                prefs = FindbugsPlugin.createDefaultUserPreferences(project);
            }
            project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)prefs);
        }
        return prefs;
    }

    public static ExtendedPreferences getExtendedPreferences(IProject project) throws CoreException {
        ExtendedPreferences prefs = (ExtendedPreferences)project.getSessionProperty(SESSION_PROPERTY_EXTENDEDPREFS);
        if (prefs == null) {
            prefs = FindbugsPlugin.readExtendedPreferences(project);
            if (prefs == null) {
                prefs = new ExtendedPreferences();
            }
            project.setSessionProperty(SESSION_PROPERTY_EXTENDEDPREFS, (Object)prefs);
        }
        return prefs;
    }

    public static void saveUserPreferences(IProject project, final UserPreferences userPrefs) throws CoreException, IOException {
        project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)userPrefs);
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        FileOutput userPrefsOutput = new FileOutput(){

            public void writeFile(OutputStream os) throws IOException {
                userPrefs.write(os);
            }

            public String getTaskDescription() {
                return "writing user preferences for project";
            }
        };
        IO.writeFile(userPrefsFile, userPrefsOutput, null);
    }

    public static void saveExtendedPreferences(IProject project, ExtendedPreferences extendedPrefs) throws CoreException, IOException {
        project.setSessionProperty(SESSION_PROPERTY_EXTENDEDPREFS, (Object)extendedPrefs);
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        if (!userPrefsFile.exists()) {
            throw new IOException("User preferences file not present yet. Save UserPreferences first.");
        }
        File prefsFile = userPrefsFile.getLocation().toFile();
        extendedPrefs.write(prefsFile);
        userPrefsFile.refreshLocal(2, null);
    }

    private static UserPreferences readUserPreferences(IProject project) throws CoreException {
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        if (!userPrefsFile.exists()) {
            return null;
        }
        try {
            InputStream in = userPrefsFile.getContents();
            UserPreferences userPrefs = UserPreferences.createDefaultUserPreferences();
            userPrefs.read(in);
            return userPrefs;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not read user preferences for project");
            return null;
        }
    }

    private static ExtendedPreferences readExtendedPreferences(IProject project) {
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        if (!userPrefsFile.exists()) {
            return null;
        }
        try {
            ExtendedPreferences prefs = new ExtendedPreferences();
            prefs.read(userPrefsFile.getLocation().toFile());
            return prefs;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not read user preferences for project");
            return null;
        }
    }

    private static UserPreferences createDefaultUserPreferences(IProject project) {
        UserPreferences userPrefs = UserPreferences.createDefaultUserPreferences();
        try {
            String activeDetectorList = (String)project.getSessionProperty(SESSION_PROPERTY_ACTIVE_DETECTORS);
            if (activeDetectorList != null) {
                userPrefs.enableAllDetectors(false);
                DetectorFactoryCollection factoryCollection = DetectorFactoryCollection.instance();
                StringTokenizer st = new StringTokenizer(activeDetectorList, LIST_DELIMITER);
                while (st.hasMoreTokens()) {
                    String factoryName = st.nextToken();
                    DetectorFactory factory = factoryCollection.getFactory(factoryName);
                    if (factory == null) continue;
                    userPrefs.enableDetector(factory, true);
                }
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not get FindBugs settings");
        }
        return userPrefs;
    }

    public BugResolutionAssociations getBugResolutions() {
        if (this.bugResolutions == null) {
            this.bugResolutions = this.loadBugResolutions();
        }
        return this.bugResolutions;
    }

    private BugResolutionAssociations loadBugResolutions() {
        BugResolutionLoader loader = new BugResolutionLoader();
        File xmlFile = new File(FindBugs.getHome() + File.separator + "plugin" + File.separator + "findbugs-resolutions.xml");
        return loader.loadBugResolutions(xmlFile);
    }

    static {
        PERSISTENT_PROPERTY_ACTIVE_DETECTORS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.persprops", "detectors.active");
        SESSION_PROPERTY_ACTIVE_DETECTORS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "detectors.active");
        PERSISTENT_PROPERTY_FILTER_SETTINGS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.persprops", "filter.settings");
        SESSION_PROPERTY_FILTER_SETTINGS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "filter.settings");
        SESSION_PROPERTY_BUG_COLLECTION = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection");
        SESSION_PROPERTY_FB_PROJECT = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "fbproject");
        SESSION_PROPERTY_BUG_COLLECTION_DIRTY = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection.dirty");
        SESSION_PROPERTY_USERPREFS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "userprefs");
        SESSION_PROPERTY_EXTENDEDPREFS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "extendedprefs");
    }
}

