/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericUtilities {
    public static final TypeCategory getTypeCategory(Type type) {
        if (type instanceof GenericObjectType) {
            return ((GenericObjectType)type).getTypeCategory();
        }
        if (type instanceof ObjectType) {
            return TypeCategory.PLAIN_OBJECT_TYPE;
        }
        if (type instanceof ArrayType) {
            return TypeCategory.ARRAY_TYPE;
        }
        return TypeCategory.NON_REFERENCE_TYPE;
    }

    public static final boolean isPlainObject(Type type) {
        return GenericUtilities.getTypeCategory(type) == TypeCategory.PLAIN_OBJECT_TYPE;
    }

    public static final String getString(Type type) {
        if (type instanceof GenericObjectType) {
            return ((GenericObjectType)type).toString(true);
        }
        if (type instanceof ArrayType) {
            return TypeCategory.asString((ArrayType)type);
        }
        return type.toString();
    }

    public static final Type getType(String signature) {
        if (new GenericSignatureParser(new StringBuffer().append("(").append(signature).append(")V").toString()).getNumParameters() != 1) {
            throw new IllegalArgumentException(new StringBuffer().append("the following signature does not contain exactly one type: ").append(signature).toString());
        }
        int index = 0;
        if (signature.startsWith("L")) {
            index = signature.indexOf(60);
            if (index < 0) {
                return Type.getType(signature);
            }
            List<Type> parameters = GenericUtilities.getTypes(signature.substring(index + 1, signature.lastIndexOf(62)));
            return new GenericObjectType(signature.substring(1, index), parameters);
        }
        if (signature.startsWith("T")) {
            return new GenericObjectType(signature.substring(1, signature.length() - 1));
        }
        if (signature.startsWith("[")) {
            index = signature.lastIndexOf(91) + 1;
            return new ArrayType(GenericUtilities.getType(signature.substring(index)), index);
        }
        if (signature.startsWith("*")) {
            return new GenericObjectType("*");
        }
        if (signature.startsWith("+") || signature.startsWith("-")) {
            return new GenericObjectType(signature.substring(0, 1), GenericUtilities.getType(signature.substring(1)));
        }
        return Type.getType(signature);
    }

    public static final List<Type> getTypes(String signature) {
        GenericSignatureParser parser = new GenericSignatureParser(new StringBuffer().append("(").append(signature).append(")V").toString());
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator<String> iter = parser.parameterSignatureIterator();
        while (iter.hasNext()) {
            String parameterString = iter.next();
            types.add(GenericUtilities.getType(parameterString));
        }
        return types;
    }

    public static abstract class TypeCategory {
        public static final TypeCategory NON_REFERENCE_TYPE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString(obj);
            }
        };
        public static final TypeCategory PLAIN_OBJECT_TYPE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString(obj);
            }
        };
        public static final TypeCategory ARRAY_TYPE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString(obj);
            }
        };
        public static final TypeCategory PARAMETERS = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                String result = obj.toString();
                result = result + "<";
                Iterator<Type> i$ = obj.parameters.iterator();
                while (i$.hasNext()) {
                    Type t = i$.next();
                    result = result + GenericUtilities.getString(t) + ",";
                }
                return result.substring(0, result.length() - 1) + ">";
            }
        };
        public static final TypeCategory TYPE_VARIABLE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return obj.variable;
            }
        };
        public static final TypeCategory WILDCARD = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return "?";
            }
        };
        public static final TypeCategory WILDCARD_EXTENDS = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return "? extends " + GenericUtilities.getString(obj.extension);
            }
        };
        public static final TypeCategory WILDCARD_SUPER = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return "? super " + GenericUtilities.getString(obj.extension);
            }
        };

        public abstract String asString(GenericObjectType var1);

        public static String asString(ArrayType atype) {
            Type obj = atype.getBasicType();
            String result = GenericUtilities.getString(obj);
            for (int i = 0; i < atype.getDimensions(); ++i) {
                result = result + "[]";
            }
            return result;
        }
    }
}

