/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.AnalysisLocal;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class PruneUnconditionalExceptionThrowerEdges
implements EdgeTypes {
    private static final boolean DEBUG = SystemProperties.getBoolean("cfg.prune.throwers.debug");
    private MethodGen methodGen;
    private CFG cfg;
    private ConstantPoolGen cpg;
    private AnalysisContext analysisContext;
    private boolean cfgModified;
    private static final BitSet RETURN_OPCODE_SET = new BitSet();
    static AnalysisLocal<Map<XMethod, Boolean>> cachedResults;

    public PruneUnconditionalExceptionThrowerEdges(MethodGen methodGen, CFG cfg, ConstantPoolGen cpg, AnalysisContext analysisContext) {
        this.methodGen = methodGen;
        this.cfg = cfg;
        this.cpg = cpg;
        this.analysisContext = analysisContext;
    }

    public void execute() throws CFGBuilderException, DataflowAnalysisException {
        AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext.getBoolProperty(1)) {
            throw new IllegalStateException("This should not happen");
        }
        HashSet<Edge> deletedEdgeSet = new HashSet<Edge>();
        if (DEBUG) {
            System.out.println("PruneUnconditionalExceptionThrowerEdges: examining " + SignatureConverter.convertMethodSignature(this.methodGen));
        }
        Subtypes subtypes = AnalysisContext.currentAnalysisContext().getSubtypes();
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            Instruction exceptionThrower;
            BasicBlock basicBlock = i.next();
            if (!basicBlock.isExceptionThrower() || !((exceptionThrower = basicBlock.getExceptionThrower().getInstruction()) instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)exceptionThrower;
            try {
                Edge fallThrough;
                Boolean isUnconditionalThrower;
                String methodSig;
                String className = inv.getClassName(this.cpg);
                if (DEBUG) {
                    System.out.println("\tlooking up method for " + basicBlock.getExceptionThrower() + " in " + className);
                }
                if (className.startsWith("[") || !(methodSig = inv.getSignature(this.cpg)).endsWith("V")) continue;
                XMethod xMethod = XFactory.createXMethod(inv, this.cpg);
                JavaClass javaClass = Repository.lookupClass(xMethod.getClassName());
                JavaClassAndMethod classAndMethod = Hierarchy.findMethod(javaClass, xMethod.getName(), xMethod.getSignature(), Hierarchy.CONCRETE_METHOD);
                if (classAndMethod == null) {
                    if (!DEBUG) continue;
                    System.out.println("\tNOT FOUND");
                    continue;
                }
                Method method = classAndMethod.getMethod();
                if (DEBUG) {
                    System.out.println("\tFound " + xMethod);
                }
                if (!method.isStatic() && !method.isPrivate() && !method.isFinal() && !javaClass.isFinal() && subtypes.hasSubtypes(javaClass) && !Repository.instanceOf(this.methodGen.getClassName(), javaClass) || method.getCode() == null || !(isUnconditionalThrower = PruneUnconditionalExceptionThrowerEdges.doesMethodUnconditionallyThrowException(xMethod, javaClass, method)).booleanValue() || (fallThrough = this.cfg.getOutgoingEdgeWithType(basicBlock, 0)) == null) continue;
                if (DEBUG) {
                    System.out.println("\tREMOVING normal return for: " + xMethod);
                }
                deletedEdgeSet.add(fallThrough);
            }
            catch (ClassNotFoundException e) {
                this.analysisContext.getLookupFailureCallback().reportMissingClass(e);
            }
        }
        Iterator i$ = deletedEdgeSet.iterator();
        while (i$.hasNext()) {
            Edge edge = (Edge)i$.next();
            this.cfg.removeEdge(edge);
            this.cfgModified = true;
        }
    }

    public static Boolean doesMethodUnconditionallyThrowException(XMethod xMethod, JavaClass javaClass, Method method) {
        Boolean isUnconditionalThrower = cachedResults.get().get(xMethod);
        if (isUnconditionalThrower == null) {
            isUnconditionalThrower = Boolean.FALSE;
            try {
                ClassContext classContext = AnalysisContext.currentAnalysisContext().getClassContext(javaClass);
                BitSet bytecodeSet = classContext.getBytecodeSet(method);
                if (bytecodeSet != null) {
                    if (DEBUG) {
                        System.out.println("\tChecking " + xMethod);
                    }
                    isUnconditionalThrower = !bytecodeSet.intersects(RETURN_OPCODE_SET);
                    if (DEBUG && isUnconditionalThrower.booleanValue()) {
                        System.out.println("Is unconditional thrower");
                        System.out.println("Return opcode set: " + RETURN_OPCODE_SET);
                        System.out.println("Code opcode set: " + bytecodeSet);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            cachedResults.get().put(xMethod, isUnconditionalThrower);
        }
        return isUnconditionalThrower;
    }

    public boolean wasCFGModified() {
        return this.cfgModified;
    }

    static {
        RETURN_OPCODE_SET.set(176);
        RETURN_OPCODE_SET.set(172);
        RETURN_OPCODE_SET.set(173);
        RETURN_OPCODE_SET.set(175);
        RETURN_OPCODE_SET.set(174);
        RETURN_OPCODE_SET.set(177);
        cachedResults = new AnalysisLocal<Map<XMethod, Boolean>>(){

            @Override
            public Map<XMethod, Boolean> initialValue() {
                return new HashMap<XMethod, Boolean>();
            }

            @Override
            public /* synthetic */ Object initialValue() {
                return this.initialValue();
            }
        };
    }
}

