/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;

public class PrintingBugReporter
extends TextUIBugReporter {
    private String stylesheet = null;
    private boolean annotationUploadFormat = false;
    private HashSet<BugInstance> seenAlready = new HashSet();

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    protected void doReportBug(BugInstance bugInstance) {
        if (this.seenAlready.add(bugInstance)) {
            this.printBug(bugInstance);
            this.notifyObservers(bugInstance);
        }
    }

    public void finish() {
        this.outputStream.close();
    }

    public static void main(String[] args) throws Exception {
        PrintingBugReporter reporter = new PrintingBugReporter();
        PrintingCommandLine commandLine = reporter.new PrintingCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + PrintingCommandLine.class.getName() + " [options] [<xml results> [<test results]] ");
        DetectorFactoryCollection.instance();
        if (reporter.stylesheet != null) {
            PrintingBugReporter.xslt(reporter.stylesheet, args, argCount);
            return;
        }
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++], new Project());
        } else {
            bugCollection.readXML(System.in, new Project());
        }
        if (argCount < args.length) {
            reporter.setOutputStream(new PrintStream(new FileOutputStream(args[argCount++]), true));
        }
        RuntimeException storedException = null;
        if (reporter.annotationUploadFormat) {
            bugCollection.computeBugHashes();
            Iterator<BugInstance> i = bugCollection.iterator();
            while (i.hasNext()) {
                BugInstance warning = i.next();
                try {
                    String fHash = "fb-" + warning.getInstanceHash() + "-" + warning.getInstanceOccurrenceNum() + "-" + warning.getInstanceOccurrenceMax();
                    System.out.print("#" + fHash);
                    String key = warning.getUserDesignationKey();
                    if (key.equals("UNCLASSIFIED") || key.equals("NEEDS_FURTHER_STUDY")) {
                        System.out.print("#-1#" + key);
                    } else if (key.equals("MUST_FIX") || key.equals("SHOULD_FIX")) {
                        System.out.print("#7#" + key);
                    } else {
                        System.out.print("#0#" + key);
                    }
                    SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
                    if (sourceLine != null) {
                        System.out.println("#" + sourceLine.getSourceFile() + "#" + sourceLine.getStartLine());
                    } else {
                        System.out.println("##");
                    }
                    System.out.println(warning.getAnnotationText());
                }
                catch (RuntimeException e) {
                    if (storedException != null) continue;
                    storedException = e;
                }
            }
        } else {
            Iterator<BugInstance> i = bugCollection.iterator();
            while (i.hasNext()) {
                BugInstance warning = i.next();
                try {
                    reporter.printBug(warning);
                }
                catch (RuntimeException e) {
                    if (storedException != null) continue;
                    storedException = e;
                }
            }
        }
        if (storedException != null) {
            throw storedException;
        }
    }

    public static void xslt(String stylesheet, String[] args, int argCount) throws Exception {
        Project proj = new Project();
        HTMLBugReporter reporter = new HTMLBugReporter(proj, stylesheet);
        BugCollection bugCollection = reporter.getBugCollection();
        if (argCount < args.length) {
            proj.setProjectFileName(args[argCount]);
            bugCollection.readXML(args[argCount++], new Project());
        } else {
            bugCollection.readXML(System.in, new Project());
        }
        if (argCount < args.length) {
            reporter.setOutputStream(new PrintStream(new FileOutputStream(args[argCount++]), true));
        }
        reporter.finish();
    }

    class PrintingCommandLine
    extends CommandLine {
        public PrintingCommandLine() {
            this.addSwitch("-longBugCodes", "use long bug codes when generating text");
            this.addSwitch("-annotationUpload", "generate annotations in upload format");
            this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-longBugCodes")) {
                PrintingBugReporter.this.setUseLongBugCodes(true);
            } else if (option.equals("-annotationUpload")) {
                PrintingBugReporter.this.annotationUploadFormat = true;
            } else if (option.equals("-html")) {
                if (!optionExtraPart.equals("")) {
                    PrintingBugReporter.this.stylesheet = optionExtraPart;
                } else {
                    PrintingBugReporter.this.stylesheet = "default.xsl";
                }
            } else {
                throw new IllegalArgumentException("Unknown option '" + option + "'");
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
        }
    }
}

