/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;

public class HTMLBugReporter
extends BugCollectionBugReporter {
    private String stylesheet;

    public HTMLBugReporter(Project project, String stylesheet) {
        super(project);
        this.stylesheet = stylesheet;
    }

    public void finish() {
        block6: {
            try {
                InputStream xslInputStream;
                Document document;
                block5: {
                    BugCollection bugCollection = this.getBugCollection();
                    bugCollection.setWithMessages(true);
                    document = bugCollection.toDocument(this.getProject());
                    if (FindBugs.DEBUG) {
                        System.out.println("Attempting to load stylesheet " + this.stylesheet);
                    }
                    try {
                        xslInputStream = new BufferedInputStream(new FileInputStream(this.stylesheet));
                    }
                    catch (FileNotFoundException fnfe) {
                        xslInputStream = this.getClass().getClassLoader().getResourceAsStream(this.stylesheet);
                        if (xslInputStream != null) break block5;
                        throw new IOException("Could not load HTML generation stylesheet " + this.stylesheet);
                    }
                }
                StreamSource xsl = new StreamSource(xslInputStream);
                xsl.setSystemId(this.stylesheet);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(xsl);
                DocumentSource source = new DocumentSource(document);
                StreamResult result = new StreamResult(this.outputStream);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                this.logError("Could not generate HTML output", e);
                if (!FindBugs.DEBUG) break block6;
                e.printStackTrace();
            }
        }
    }
}

