/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    static Map map;
    private String class_name;

    public static ObjectType getInstance(String class_name) {
        ObjectType result;
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
        }
        if ((result = (ObjectType)map.get(class_name)) != null) {
            return result;
        }
        result = class_name.indexOf(46) >= 0 ? new ObjectType(class_name, class_name.replace('.', '/')) : new ObjectType(class_name.replace('/', '.'), class_name);
        map.put(class_name, result);
        return result;
    }

    private ObjectType(String dottedClassName, String slashedClassName) {
        super((byte)14, "L" + slashedClassName + ";");
        this.class_name = dottedClassName;
    }

    public ObjectType(String class_name) {
        super((byte)14, "L" + class_name.replace('.', '/') + ";");
        this.class_name = class_name.replace('/', '.');
    }

    public String getClassName() {
        return this.class_name;
    }

    public int hashCode() {
        return this.class_name.hashCode();
    }

    public boolean equals(Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    public boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return jc.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return !jc.isClass();
    }

    public boolean subclassOf(ObjectType superclass) throws ClassNotFoundException {
        if (this.referencesInterface() || superclass.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public boolean accessibleTo(ObjectType accessor) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

