/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTFunDecl;
import Mini.ASTIdent;
import Mini.EnvEntry;
import Mini.Environment;
import Mini.Function;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.MiniParserConstants;
import Mini.MiniParserTreeConstants;
import Mini.Node;
import Mini.SimpleNode;
import Mini.Variable;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;

public class ASTProgram
extends SimpleNode
implements MiniParserConstants,
MiniParserTreeConstants,
Constants {
    private ASTFunDecl[] fun_decls;
    private Environment env;

    ASTProgram(int id2) {
        super(id2);
        this.env = new Environment();
        ASTIdent ident = new ASTIdent("WRITE", 10, -1, -1);
        ASTIdent[] args = new ASTIdent[]{new ASTIdent("", 10, -1, -1)};
        Function fun = new Function(ident, args, true);
        this.env.put(fun);
        ident = new ASTIdent("READ", 10, -1, -1);
        args = new ASTIdent[]{};
        fun = new Function(ident, args, true);
        this.env.put(fun);
        ident = new ASTIdent("TRUE", 4, -1, -1);
        Variable var = new Variable(ident, true);
        this.env.put(var);
        ident = new ASTIdent("FALSE", 4, -1, -1);
        var = new Variable(ident, true);
        this.env.put(var);
    }

    ASTProgram(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTProgram(p, id2);
    }

    public void closeNode() {
        if (this.children != null) {
            this.fun_decls = new ASTFunDecl[this.children.length];
            System.arraycopy(this.children, 0, this.fun_decls, 0, this.children.length);
            this.children = null;
        }
    }

    public ASTProgram traverse() {
        Function main = null;
        if (this.fun_decls != null) {
            String fname;
            int i = 0;
            while (i < this.fun_decls.length) {
                ASTFunDecl f = this.fun_decls[i];
                ASTIdent name = f.getName();
                fname = name.getName();
                EnvEntry fun = this.env.get(fname);
                if (fun != null) {
                    MiniC.addError(f.getLine(), f.getColumn(), "Redeclaration of " + fun + ".");
                } else {
                    this.env.put(new Function(name, null));
                }
                ++i;
            }
            i = 0;
            while (i < this.fun_decls.length) {
                this.fun_decls[i] = this.fun_decls[i].traverse((Environment)this.env.clone());
                fname = this.fun_decls[i].getName().getName();
                if (fname.equals("main")) {
                    main = (Function)this.env.get(fname);
                }
                ++i;
            }
            if (main == null) {
                MiniC.addError(0, 0, "You didn't declare a `main' function.");
            } else if (main.getNoArgs() != 0) {
                MiniC.addError(main.getLine(), main.getColumn(), "Main function has too many arguments declared.");
            }
        }
        return this;
    }

    public void eval(int pass) {
        int i = 0;
        while (i < this.fun_decls.length) {
            ASTIdent name;
            this.fun_decls[i].eval(pass);
            if (pass == 3 && (name = this.fun_decls[i].getName()).getType() == 15) {
                MiniC.addError(name.getColumn(), name.getLine(), "Type of function " + name.getName() + " can not be determined (infinite recursion?).");
            }
            ++i;
        }
    }

    public void code(PrintWriter out, String name) {
        out.println("import java.io.BufferedReader;");
        out.println("import java.io.InputStreamReader;");
        out.println("import java.io.IOException;\n");
        out.println("public final class " + name + " {");
        out.println("  private static BufferedReader _in = new BufferedReader(new InputStreamReader(System.in));\n");
        out.println("  private static final int _readInt() throws IOException {\n    System.out.print(\"Please enter a number> \");\n    return Integer.parseInt(_in.readLine());\n  }\n");
        out.println("  private static final int _writeInt(int n) {\n    System.out.println(\"Result: \" + n);\n    return 0;\n  }\n");
        int i = 0;
        while (i < this.fun_decls.length) {
            this.fun_decls[i].code(out);
            ++i;
        }
        out.println("}");
    }

    public void byte_code(ClassGen class_gen, ConstantPoolGen cp) {
        class_gen.addField(new Field(10, cp.addUtf8("_in"), cp.addUtf8("Ljava/io/BufferedReader;"), null, cp.getConstantPool()));
        InstructionList il = new InstructionList();
        String class_name = class_gen.getClassName();
        int _in = cp.addFieldref(class_name, "_in", "Ljava/io/BufferedReader;");
        int out = cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        il.append(new GETSTATIC(out));
        il.append(new PUSH(cp, "Please enter a number> "));
        il.append(new INVOKEVIRTUAL(cp.addMethodref("java.io.PrintStream", "print", "(Ljava/lang/String;)V")));
        il.append(new GETSTATIC(_in));
        il.append(new INVOKEVIRTUAL(cp.addMethodref("java.io.BufferedReader", "readLine", "()Ljava/lang/String;")));
        il.append(new INVOKESTATIC(cp.addMethodref("java.lang.Integer", "parseInt", "(Ljava/lang/String;)I")));
        il.append(InstructionConstants.IRETURN);
        MethodGen method = new MethodGen(26, Type.INT, Type.NO_ARGS, null, "_readInt", class_name, il, cp);
        method.addException("java.io.IOException");
        method.setMaxStack(2);
        class_gen.addMethod(method.getMethod());
        Type[] args = new Type[]{Type.INT};
        String[] argv = new String[]{"i"};
        il = new InstructionList();
        il.append(new GETSTATIC(out));
        il.append(new NEW(cp.addClass("java.lang.StringBuffer")));
        il.append(InstructionConstants.DUP);
        il.append(new PUSH(cp, "Result: "));
        il.append(new INVOKESPECIAL(cp.addMethodref("java.lang.StringBuffer", "<init>", "(Ljava/lang/String;)V")));
        il.append(new ILOAD(0));
        il.append(new INVOKEVIRTUAL(cp.addMethodref("java.lang.StringBuffer", "append", "(I)Ljava/lang/StringBuffer;")));
        il.append(new INVOKEVIRTUAL(cp.addMethodref("java.lang.StringBuffer", "toString", "()Ljava/lang/String;")));
        il.append(new INVOKEVIRTUAL(cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V")));
        il.append(new PUSH(cp, 0));
        il.append(InstructionConstants.IRETURN);
        method = new MethodGen(26, Type.INT, args, argv, "_writeInt", class_name, il, cp);
        method.setMaxStack(4);
        class_gen.addMethod(method.getMethod());
        il.dispose();
        il = new InstructionList();
        il.append(new ALOAD(0));
        il.append(new INVOKESPECIAL(cp.addMethodref("java.lang.Object", "<init>", "()V")));
        il.append(new RETURN());
        method = new MethodGen(1, Type.VOID, Type.NO_ARGS, null, "<init>", class_name, il, cp);
        method.setMaxStack(1);
        class_gen.addMethod(method.getMethod());
        il.dispose();
        il = new InstructionList();
        il.append(new NEW(cp.addClass("java.io.BufferedReader")));
        il.append(InstructionConstants.DUP);
        il.append(new NEW(cp.addClass("java.io.InputStreamReader")));
        il.append(InstructionConstants.DUP);
        il.append(new GETSTATIC(cp.addFieldref("java.lang.System", "in", "Ljava/io/InputStream;")));
        il.append(new INVOKESPECIAL(cp.addMethodref("java.io.InputStreamReader", "<init>", "(Ljava/io/InputStream;)V")));
        il.append(new INVOKESPECIAL(cp.addMethodref("java.io.BufferedReader", "<init>", "(Ljava/io/Reader;)V")));
        il.append(new PUTSTATIC(_in));
        il.append(InstructionConstants.RETURN);
        method = new MethodGen(8, Type.VOID, Type.NO_ARGS, null, "<clinit>", class_name, il, cp);
        method.setMaxStack(5);
        class_gen.addMethod(method.getMethod());
        int i = 0;
        while (i < this.fun_decls.length) {
            this.fun_decls[i].byte_code(class_gen, cp);
            ++i;
        }
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        int i = 0;
        while (i < this.fun_decls.length) {
            this.fun_decls[i].dump(String.valueOf(prefix) + " ");
            ++i;
        }
    }
}

