/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTExpr;
import Mini.ASTFunDecl;
import Mini.ASTIdent;
import Mini.EnvEntry;
import Mini.Environment;
import Mini.Function;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.MiniParserTreeConstants;
import Mini.Node;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class ASTFunAppl
extends ASTExpr
implements MiniParserTreeConstants,
Constants {
    private ASTIdent name;
    private Function function;

    ASTFunAppl(int id2) {
        super(id2);
    }

    ASTFunAppl(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTFunAppl(p, id2);
    }

    ASTFunAppl(ASTIdent name, Function function, ASTExpr[] exprs) {
        this(5);
        this.name = name;
        this.function = function;
        this.exprs = exprs;
    }

    public String toString() {
        return String.valueOf(jjtNodeName[this.id]) + " " + this.name.getName();
    }

    public void closeNode() {
        this.name = (ASTIdent)this.children[0];
        if (this.children.length > 1) {
            this.exprs = new ASTExpr[this.children.length - 1];
            System.arraycopy(this.children, 1, this.exprs, 0, this.children.length - 1);
        }
        this.children = null;
    }

    public ASTExpr traverse(Environment env) {
        String fname = this.name.getName();
        EnvEntry entry = env.get(fname);
        this.env = env;
        if (entry == null) {
            MiniC.addError(this.name.getLine(), this.name.getColumn(), "Applying unknown function " + fname + ".");
        } else if (!(entry instanceof Function)) {
            MiniC.addError(this.name.getLine(), this.name.getColumn(), "Applying non-function " + fname + ".");
        } else {
            Function fun;
            int len = this.exprs != null ? this.exprs.length : 0;
            if (len != (fun = (Function)entry).getNoArgs()) {
                MiniC.addError(this.name.getLine(), this.name.getColumn(), "Function " + fname + " expects " + fun.getNoArgs() + " arguments, you supplied " + len + ".");
            } else {
                this.function = fun;
                this.name = fun.getName();
            }
        }
        if (this.exprs != null) {
            int i = 0;
            while (i < this.exprs.length) {
                this.exprs[i] = this.exprs[i].traverse(env);
                ++i;
            }
        }
        return this;
    }

    public int eval(int expected) {
        String fname = this.name.getName();
        Function f = this.function;
        ASTIdent fun = f.getName();
        ASTIdent[] args = f.getArgs();
        int t = fun.getType();
        this.is_simple = true;
        if (this.exprs != null) {
            int i = 0;
            while (i < this.exprs.length) {
                int expect = args[i].getType();
                int t_e = this.exprs[i].eval(expect);
                if (expect != 15 && t_e != expect) {
                    MiniC.addError(this.exprs[i].getLine(), this.exprs[i].getColumn(), "Argument " + (i + 1) + " in application of " + fname + " is not of type " + TYPE_NAMES[expect] + " but " + TYPE_NAMES[t_e]);
                } else {
                    args[i].setType(t_e);
                }
                this.is_simple = this.is_simple && this.exprs[i].isSimple();
                ++i;
            }
        }
        if (t == 15) {
            t = expected;
            fun.setType(t);
        }
        this.type = t;
        return this.type;
    }

    public void code(StringBuffer buf) {
        String fname = this.name.getName();
        Function f = this.function;
        ASTIdent[] args = f.getArgs();
        if (fname.equals("READ")) {
            ASTFunDecl.push(buf, "_readInt()");
        } else if (fname.equals("WRITE")) {
            this.exprs[0].code(buf);
            ASTFunDecl.push(buf, "_writeInt(" + ASTFunDecl.pop() + ")");
        } else {
            if (this.exprs != null) {
                int i = this.exprs.length - 1;
                while (i >= 0) {
                    this.exprs[i].code(buf);
                    --i;
                }
            }
            StringBuffer call = new StringBuffer(String.valueOf(fname) + "(");
            if (this.exprs != null) {
                int i = 0;
                while (i < this.exprs.length) {
                    call.append(ASTFunDecl.pop());
                    if (i < this.exprs.length - 1) {
                        call.append(", ");
                    }
                    ++i;
                }
            }
            call.append(")");
            ASTFunDecl.push(buf, call.toString());
        }
    }

    public void byte_code(InstructionList il, MethodGen method, ConstantPoolGen cp) {
        String fname = this.name.getName();
        Function f = this.function;
        ASTIdent[] args = f.getArgs();
        String class_name = method.getClassName();
        if (fname.equals("READ")) {
            il.append(new INVOKESTATIC(cp.addMethodref(class_name, "_readInt", "()I")));
        } else if (fname.equals("WRITE")) {
            this.exprs[0].byte_code(il, method, cp);
            ASTFunDecl.pop();
            il.append(new INVOKESTATIC(cp.addMethodref(class_name, "_writeInt", "(I)I")));
        } else {
            int size = this.exprs.length;
            Type[] argv = null;
            if (this.exprs != null) {
                argv = new Type[size];
                int i = 0;
                while (i < size) {
                    argv[i] = Type.INT;
                    this.exprs[i].byte_code(il, method, cp);
                    ++i;
                }
            }
            ASTFunDecl.pop(size);
            il.append(new INVOKESTATIC(cp.addMethodref(class_name, fname, Type.getMethodSignature(Type.INT, argv))));
        }
        ASTFunDecl.push();
    }

    public ASTIdent getName() {
        return this.name;
    }

    public Function getFunction() {
        return this.function;
    }
}

