/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreadFields
extends BytecodeScanningDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"unreadfields.debug");
    Map<XField, HashSet<ProgramPoint>> assumedNonNull = new HashMap<XField, HashSet<ProgramPoint>>();
    Set<XField> nullTested = new HashSet<XField>();
    Set<XField> staticFields = new HashSet<XField>();
    Set<XField> declaredFields = new TreeSet<XField>();
    Set<XField> containerFields = new TreeSet<XField>();
    Set<String> abstractClasses = new HashSet<String>();
    Set<String> hasNonAbstractSubClass = new HashSet<String>();
    Set<String> classesScanned = new HashSet<String>();
    Set<XField> fieldsOfNativeClassed = new HashSet<XField>();
    Set<XField> fieldsOfSerializableOrNativeClassed = new HashSet<XField>();
    Set<XField> staticFieldsReadInThisMethod = new HashSet<XField>();
    Set<XField> allMyFields = new TreeSet<XField>();
    Set<XField> myFields = new TreeSet<XField>();
    Set<XField> writtenFields = new HashSet<XField>();
    Map<XField, SourceLineAnnotation> fieldAccess = new HashMap<XField, SourceLineAnnotation>();
    Set<XField> writtenNonNullFields = new HashSet<XField>();
    Set<String> calledFromConstructors = new HashSet<String>();
    Set<XField> writtenInConstructorFields = new HashSet<XField>();
    Set<XField> writtenOutsideOfConstructorFields = new HashSet<XField>();
    Set<XField> readFields = new HashSet<XField>();
    Set<XField> constantFields = new HashSet<XField>();
    Set<XField> finalFields = new HashSet<XField>();
    Set<String> needsOuterObjectInConstructor = new HashSet<String>();
    Set<String> innerClassCannotBeStatic = new HashSet<String>();
    boolean hasNativeMethods;
    boolean isSerializable;
    boolean sawSelfCallInConstructor;
    private BugReporter bugReporter;
    boolean publicOrProtectedConstructor;
    private XFactory xFactory = AnalysisContext.currentXFactory();
    static final int doNotConsider = 5;
    int count_aload_1;
    private OpcodeStack opcodeStack = new OpcodeStack();
    private int previousOpcode;
    private int previousPreviousOpcode;
    boolean seenInvokeStatic;
    Pattern dontComplainAbout = Pattern.compile("class[$]");

    public Set<? extends XField> getReadFields() {
        return this.readFields;
    }

    public Set<? extends XField> getWrittenFields() {
        return this.writtenFields;
    }

    public Set<? extends XField> getWrittenOutsideOfConstructorFields() {
        return this.writtenOutsideOfConstructorFields;
    }

    public UnreadFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        context.setUnreadFields(this);
    }

    public void visit(JavaClass obj) {
        String[] interface_names;
        this.calledFromConstructors.clear();
        this.hasNativeMethods = false;
        this.sawSelfCallInConstructor = false;
        this.publicOrProtectedConstructor = false;
        this.isSerializable = false;
        if (obj.isAbstract()) {
            this.abstractClasses.add(this.getDottedClassName());
        } else {
            String superClass = obj.getSuperclassName();
            if (superClass != null) {
                this.hasNonAbstractSubClass.add(superClass);
            }
        }
        if (this.getSuperclassName().indexOf("$") >= 0 || this.getSuperclassName().indexOf("+") >= 0) {
            this.innerClassCannotBeStatic.add(this.getDottedClassName());
            this.innerClassCannotBeStatic.add(this.getDottedSuperclassName());
        }
        for (String interface_name : interface_names = obj.getInterfaceNames()) {
            if (interface_name.equals("java.io.Externalizable")) {
                this.isSerializable = true;
                continue;
            }
            if (!interface_name.equals("java.io.Serializable")) continue;
            this.isSerializable = true;
            break;
        }
        if (!this.isSerializable) {
            try {
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Externalizable")) {
                    this.isSerializable = true;
                }
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                    this.isSerializable = true;
                }
                if (Repository.instanceOf((JavaClass)obj, (String)"java.rmi.Remote")) {
                    this.isSerializable = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        super.visit(obj);
    }

    public static boolean classHasParameter(JavaClass obj) {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof Signature)) continue;
            String sig = ((Signature)a).getSignature();
            return sig.charAt(0) == '<';
        }
        return false;
    }

    public void visitAfter(JavaClass obj) {
        this.declaredFields.addAll(this.myFields);
        if (this.hasNativeMethods) {
            this.fieldsOfSerializableOrNativeClassed.addAll(this.myFields);
            this.fieldsOfNativeClassed.addAll(this.myFields);
        }
        if (this.isSerializable) {
            this.fieldsOfSerializableOrNativeClassed.addAll(this.myFields);
        }
        if (this.sawSelfCallInConstructor) {
            this.writtenInConstructorFields.addAll(this.myFields);
        }
        this.myFields.clear();
        this.allMyFields.clear();
        this.calledFromConstructors.clear();
    }

    public void visit(Field obj) {
        super.visit(obj);
        XField f = XFactory.createXField((PreorderVisitor)this);
        this.allMyFields.add(f);
        int flags = obj.getAccessFlags();
        if ((flags & 5) == 0 && !this.getFieldName().equals("serialVersionUID")) {
            this.myFields.add(f);
            if (obj.isFinal()) {
                this.finalFields.add(f);
            }
            if (obj.isStatic()) {
                this.staticFields.add(f);
            }
            if (obj.getName().equals("_jspx_dependants")) {
                this.containerFields.add(f);
            }
        }
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (!this.visitingField()) {
            return;
        }
        if (annotationClass.startsWith("javax.annotation.") || annotationClass.startsWith("javax.ejb") || annotationClass.equals("org.jboss.seam.annotations.In") || annotationClass.startsWith("javax.persistence")) {
            this.containerFields.add(XFactory.createXField((PreorderVisitor)this));
        }
    }

    public void visit(ConstantValue obj) {
        XField f = XFactory.createXField((PreorderVisitor)this);
        this.constantFields.add(f);
    }

    public void visit(Code obj) {
        this.count_aload_1 = 0;
        this.previousOpcode = -1;
        this.previousPreviousOpcode = -1;
        this.nullTested.clear();
        this.seenInvokeStatic = false;
        this.opcodeStack.resetForMethodEntry((DismantleBytecode)this);
        this.staticFieldsReadInThisMethod.clear();
        super.visit(obj);
        if (this.getMethodName().equals("<init>") && this.count_aload_1 > 1 && (this.getClassName().indexOf(36) >= 0 || this.getClassName().indexOf(43) >= 0)) {
            this.needsOuterObjectInConstructor.add(this.getDottedClassName());
        }
    }

    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Checking ").append(this.getClassName()).append(".").append(obj.getName()).toString());
        }
        if (this.getMethodName().equals("<init>") && (obj.isPublic() || obj.isProtected())) {
            this.publicOrProtectedConstructor = true;
        }
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0x100) != 0) {
            this.hasNativeMethods = true;
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        XField f;
        XField f2;
        this.opcodeStack.mergeJumps((DismantleBytecode)this);
        if (seen == 178) {
            f2 = XFactory.createReferencedXField((DismantleBytecode)this);
            this.staticFieldsReadInThisMethod.add(f2);
        } else if (seen == 184) {
            this.seenInvokeStatic = true;
        } else if (seen == 179 && !this.getMethod().isStatic() && !this.staticFieldsReadInThisMethod.contains(f2 = XFactory.createReferencedXField((DismantleBytecode)this))) {
            int priority = 3;
            if (!this.publicOrProtectedConstructor) {
                --priority;
            }
            if (!this.seenInvokeStatic && this.staticFieldsReadInThisMethod.isEmpty()) {
                --priority;
            }
            if (this.getThisClass().isPublic() && this.getMethod().isPublic()) {
                --priority;
            }
            if (this.getThisClass().isPrivate() || this.getMethod().isPrivate()) {
                ++priority;
            }
            if (this.getClassName().indexOf(36) != -1) {
                ++priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", priority).addClassAndMethod((PreorderVisitor)this).addField(f2).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
            String sig = this.getSigConstantOperand();
            String invokedClassName = this.getClassConstantOperand();
            if (invokedClassName.equals(this.getClassName()) && (this.getMethodName().equals("<init>") || this.getMethodName().equals("<clinit>"))) {
                this.calledFromConstructors.add(new StringBuffer().append(this.getNameConstantOperand()).append(":").append(sig).toString());
            }
            int pos = PreorderVisitor.getNumberArguments((String)sig);
            if (this.opcodeStack.getStackDepth() > pos) {
                boolean selfCall;
                boolean superCall;
                OpcodeStack.Item item2 = this.opcodeStack.getStackItem(pos);
                boolean bl = superCall = seen == 183 && !invokedClassName.equals(this.getClassName());
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("In ").append(this.getFullyQualifiedMethodName()).append(" saw call on ").append(item2).toString());
                }
                boolean bl2 = selfCall = item2.getRegisterNumber() == 0 && !superCall;
                if (selfCall && this.getMethodName().equals("<init>")) {
                    this.sawSelfCallInConstructor = true;
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("Saw self call in ").append(this.getFullyQualifiedMethodName()).append(" to ").append(invokedClassName).append(".").append(this.getNameConstantOperand()).toString());
                    }
                }
            }
        }
        if ((seen == 198 || seen == 199) && this.opcodeStack.getStackDepth() > 0 && (f = (item = this.opcodeStack.getStackItem(0)).getXField()) != null) {
            this.nullTested.add(f);
            if (DEBUG) {
                System.out.println(new StringBuffer().append(f).append(" null checked in ").append(this.getFullyQualifiedMethodName()).toString());
            }
        }
        if (seen == 180 || seen == 182 || seen == 185 || seen == 183 || seen == 181 || seen == 46 || seen == 50 || seen == 51 || seen == 52 || seen == 53 || seen == 79 || seen == 83 || seen == 84 || seen == 85 || seen == 86 || seen == 190) {
            int pos = 0;
            switch (seen) {
                case 180: 
                case 190: {
                    pos = 0;
                    break;
                }
                case 182: 
                case 183: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    pos = PreorderVisitor.getNumberArguments((String)sig);
                    break;
                }
                case 46: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 181: {
                    pos = 1;
                    break;
                }
                case 79: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    pos = 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Impossible");
                }
            }
            if (this.opcodeStack.getStackDepth() >= pos) {
                OpcodeStack.Item item3 = this.opcodeStack.getStackItem(pos);
                XField f3 = item3.getXField();
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("RRR: ").append(f3).append(" ").append(this.nullTested.contains(f3)).append(" ").append(this.writtenInConstructorFields.contains(f3)).append(" ").append(this.writtenNonNullFields.contains(f3)).toString());
                }
                if (!(f3 == null || this.nullTested.contains(f3) || this.writtenInConstructorFields.contains(f3) && this.writtenNonNullFields.contains(f3))) {
                    ProgramPoint p = new ProgramPoint(this);
                    HashSet<ProgramPoint> s = this.assumedNonNull.get(f3);
                    if (s == null) {
                        s = new HashSet();
                        this.assumedNonNull.put(f3, s);
                    }
                    s.add(p);
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append(f3).append(" assumed non-null in ").append(this.getFullyQualifiedMethodName()).toString());
                    }
                }
            }
        }
        if (seen == 43) {
            ++this.count_aload_1;
        } else if (seen == 180 || seen == 178) {
            f = XFactory.createReferencedXField((DismantleBytecode)this);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("get: ").append(f).toString());
            }
            this.readFields.add(f);
            if (!this.fieldAccess.containsKey(f)) {
                this.fieldAccess.put(f, SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
            }
        } else if (seen == 181 || seen == 179) {
            f = XFactory.createReferencedXField((DismantleBytecode)this);
            OpcodeStack.Item item4 = null;
            if (this.opcodeStack.getStackDepth() > 0 && !(item4 = this.opcodeStack.getStackItem(0)).isNull()) {
                this.nullTested.add(f);
            }
            this.writtenFields.add(f);
            if (!this.fieldAccess.containsKey(f)) {
                this.fieldAccess.put(f, SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
            }
            if (this.previousOpcode != 1 || this.previousPreviousOpcode == 167) {
                this.writtenNonNullFields.add(f);
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("put nn: ").append(f).toString());
                }
            } else if (DEBUG) {
                System.out.println(new StringBuffer().append("put: ").append(f).toString());
            }
            if (this.getMethod().isStatic() == f.isStatic() && (this.calledFromConstructors.contains(new StringBuffer().append(this.getMethodName()).append(":").append(this.getMethodSig()).toString()) || this.getMethodName().equals("<init>") || this.getMethodName().equals("init") || this.getMethodName().equals("init") || this.getMethodName().equals("initialize") || this.getMethodName().equals("<clinit>") || this.getMethod().isPrivate())) {
                this.writtenInConstructorFields.add(f);
                if (this.previousOpcode != 1 || this.previousPreviousOpcode == 167) {
                    this.assumedNonNull.remove(f);
                }
            } else {
                this.writtenOutsideOfConstructorFields.add(f);
            }
        }
        this.opcodeStack.sawOpcode((DismantleBytecode)this, seen);
        this.previousPreviousOpcode = this.previousOpcode;
        this.previousOpcode = seen;
    }

    public void report() {
        int priority;
        String fieldSignature;
        String className;
        String fieldName;
        HashSet<String> fieldNamesSet = new HashSet<String>();
        for (XField f : this.writtenNonNullFields) {
            fieldNamesSet.add(f.getName());
        }
        if (DEBUG) {
            System.out.println("read fields:");
            for (XField f : this.readFields) {
                System.out.println(new StringBuffer().append("  ").append(f).toString());
            }
            if (!this.containerFields.isEmpty()) {
                System.out.println("ejb3 fields:");
                for (XField f : this.containerFields) {
                    System.out.println(new StringBuffer().append("  ").append(f).toString());
                }
            }
            System.out.println("written fields:");
            for (XField f : this.writtenFields) {
                System.out.println(new StringBuffer().append("  ").append(f).toString());
            }
            System.out.println("written nonnull fields:");
            for (XField f : this.writtenNonNullFields) {
                System.out.println(new StringBuffer().append("  ").append(f).toString());
            }
            System.out.println("assumed nonnull fields:");
            for (XField f : this.assumedNonNull.keySet()) {
                System.out.println(new StringBuffer().append("  ").append(f).toString());
            }
        }
        this.declaredFields.removeAll(this.containerFields);
        TreeSet<XField> notInitializedInConstructors = new TreeSet<XField>(this.declaredFields);
        notInitializedInConstructors.retainAll(this.readFields);
        notInitializedInConstructors.retainAll(this.writtenFields);
        notInitializedInConstructors.retainAll(this.assumedNonNull.keySet());
        notInitializedInConstructors.removeAll(this.staticFields);
        notInitializedInConstructors.removeAll(this.writtenInConstructorFields);
        TreeSet<XField> readOnlyFields = new TreeSet<XField>(this.declaredFields);
        readOnlyFields.removeAll(this.writtenFields);
        readOnlyFields.retainAll(this.readFields);
        TreeSet<XField> nullOnlyFields = new TreeSet<XField>(this.declaredFields);
        nullOnlyFields.removeAll(this.writtenNonNullFields);
        nullOnlyFields.retainAll(this.readFields);
        Set<XField> writeOnlyFields = this.declaredFields;
        writeOnlyFields.removeAll(this.readFields);
        for (XField f : notInitializedInConstructors) {
            fieldName = f.getName();
            className = f.getClassName();
            fieldSignature = f.getSignature();
            if (!f.isResolved() || this.fieldsOfNativeClassed.contains(f) || fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') continue;
            priority = 3;
            if (!this.assumedNonNull.containsKey(f)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", priority).addClass(className).addField(f));
        }
        for (XField f : readOnlyFields) {
            fieldName = f.getName();
            className = f.getClassName();
            fieldSignature = f.getSignature();
            if (!f.isResolved() || this.fieldsOfNativeClassed.contains(f)) continue;
            priority = 2;
            if (fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') {
                ++priority;
            }
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance((Detector)this, "UWF_UNWRITTEN_FIELD", priority), f));
        }
        for (XField f : nullOnlyFields) {
            fieldName = f.getName();
            className = f.getClassName();
            fieldSignature = f.getSignature();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Null only: ").append(f).toString());
                System.out.println(new StringBuffer().append("   : ").append(this.assumedNonNull.containsKey(f)).toString());
                System.out.println(new StringBuffer().append("   : ").append(this.fieldsOfSerializableOrNativeClassed.contains(f)).toString());
                System.out.println(new StringBuffer().append("   : ").append(fieldNamesSet.contains(f.getName())).toString());
                System.out.println(new StringBuffer().append("   : ").append(this.abstractClasses.contains(f.getClassName())).toString());
                System.out.println(new StringBuffer().append("   : ").append(this.hasNonAbstractSubClass.contains(f.getClassName())).toString());
                System.out.println(new StringBuffer().append("   : ").append(f.isResolved()).toString());
            }
            if (!f.isResolved() || this.fieldsOfNativeClassed.contains(f)) continue;
            if (DEBUG) {
                System.out.println("Ready to report");
            }
            priority = 2;
            if (this.abstractClasses.contains(f.getClassName())) {
                ++priority;
                if (!this.hasNonAbstractSubClass.contains(f.getClassName())) {
                    ++priority;
                }
            }
            if (this.assumedNonNull.containsKey(f)) {
                --priority;
                for (ProgramPoint p : this.assumedNonNull.get(f)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NP_UNWRITTEN_FIELD", 2).addClassAndMethod(p.method).addField(f).addSourceLine(p.sourceLine));
                }
            } else {
                if (f.isStatic()) {
                    ++priority;
                }
                if (this.finalFields.contains(f)) {
                    ++priority;
                }
                if (this.fieldsOfSerializableOrNativeClassed.contains(f)) {
                    ++priority;
                }
            }
            if (readOnlyFields.contains(f)) continue;
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance((Detector)this, "UWF_NULL_FIELD", priority), f).lowerPriorityIfDeprecated());
        }
        for (XField f : writeOnlyFields) {
            boolean isAnonymousInnerClass;
            fieldName = f.getName();
            className = f.getClassName();
            int lastDollar = Math.max(className.lastIndexOf(36), className.lastIndexOf(43));
            boolean bl = isAnonymousInnerClass = lastDollar > 0 && lastDollar < className.length() - 1 && Character.isDigit(className.charAt(className.length() - 1));
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Checking write only field ").append(className).append(".").append(fieldName).append("\t").append(this.constantFields.contains(f)).append("\t").append(f.isStatic()).toString());
            }
            if (!f.isResolved() || this.dontComplainAbout.matcher(fieldName).find()) continue;
            if (fieldName.startsWith("this$") || fieldName.startsWith("this+")) {
                boolean easyChange;
                String outerClassName = className.substring(0, lastDollar);
                try {
                    JavaClass outerClass = Repository.lookupClass((String)outerClassName);
                    if (UnreadFields.classHasParameter(outerClass)) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
                if (this.innerClassCannotBeStatic.contains(className)) continue;
                boolean bl2 = easyChange = !this.needsOuterObjectInConstructor.contains(className);
                if (!easyChange && isAnonymousInnerClass) continue;
                int priority2 = 3;
                if (easyChange && !isAnonymousInnerClass) {
                    priority2 = 2;
                }
                String bug = "SIC_INNER_SHOULD_BE_STATIC";
                if (isAnonymousInnerClass) {
                    bug = "SIC_INNER_SHOULD_BE_STATIC_ANON";
                } else if (!easyChange) {
                    bug = "SIC_INNER_SHOULD_BE_STATIC_NEEDS_THIS";
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, bug, priority2).addClass(className));
                continue;
            }
            if (this.constantFields.contains(f)) {
                if (f.isStatic()) continue;
                this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance((Detector)this, "SS_SHOULD_BE_STATIC", 2), f));
                continue;
            }
            if (this.fieldsOfSerializableOrNativeClassed.contains(f)) continue;
            if (!this.writtenFields.contains(f) && f.isResolved()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "UUF_UNUSED_FIELD", 2).addClass(className).addField(f).lowerPriorityIfDeprecated());
                continue;
            }
            if (f.getName().toLowerCase().indexOf("guardian") >= 0) continue;
            int priority3 = 2;
            if (f.isStatic()) {
                ++priority3;
            }
            if (this.finalFields.contains(f)) {
                ++priority3;
            }
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance((Detector)this, "URF_UNREAD_FIELD", priority3), f));
        }
    }

    private BugInstance addClassFieldAndAccess(BugInstance instance, XField f) {
        instance.addClass(f.getClassName()).addField(f);
        if (this.fieldAccess.containsKey(f)) {
            instance.add((BugAnnotation)this.fieldAccess.get(f));
        }
        return instance;
    }

    static class ProgramPoint {
        MethodAnnotation method;
        SourceLineAnnotation sourceLine;

        ProgramPoint(BytecodeScanningDetector v) {
            this.method = MethodAnnotation.fromVisitedMethod((PreorderVisitor)v);
            this.sourceLine = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)v, (int)v.getPC());
        }
    }
}

