/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.Code;

public class FindFloatEquality
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final int SAW_NOTHING = 0;
    private static final int SAW_COMP = 1;
    private int priority;
    private BugReporter bugReporter;
    private OpcodeStack opStack = new OpcodeStack();
    private int state;
    Collection<SourceLineAnnotation> found = new LinkedList<SourceLineAnnotation>();

    public FindFloatEquality(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.found.clear();
        this.priority = 3;
        this.opStack.resetForMethodEntry((DismantleBytecode)this);
        this.state = 0;
        super.visit(obj);
        if (!this.found.isEmpty()) {
            BugInstance bug = new BugInstance((Detector)this, "FE_FLOATING_POINT_EQUALITY", this.priority).addClassAndMethod((PreorderVisitor)this);
            Iterator<SourceLineAnnotation> i$ = this.found.iterator();
            while (i$.hasNext()) {
                SourceLineAnnotation s = i$.next();
                bug.add((BugAnnotation)s);
            }
            this.bugReporter.reportBug(bug);
            this.found.clear();
        }
    }

    public boolean okValueToCompareAgainst(Number n) {
        if (n == null) {
            return false;
        }
        double v = n.doubleValue();
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            return true;
        }
        return (v -= Math.floor(v)) == 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        this.opStack.mergeJumps((DismantleBytecode)this);
        try {
            switch (seen) {
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    if (this.opStack.getStackDepth() < 2) return;
                    OpcodeStack.Item first = this.opStack.getStackItem(0);
                    OpcodeStack.Item second = this.opStack.getStackItem(1);
                    Number n1 = (Number)first.getConstant();
                    Number n2 = (Number)second.getConstant();
                    if (n1 != null && Double.isNaN(n1.doubleValue()) || n2 != null && Double.isNaN(n2.doubleValue())) {
                        BugInstance bug = new BugInstance((Detector)this, "FE_TEST_IF_EQUAL_TO_NOT_A_NUMBER", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
                        this.bugReporter.reportBug(bug);
                        this.state = 0;
                        return;
                    }
                    if (first.getSpecialKind() == 7 && !this.okValueToCompareAgainst(n2) || second.getSpecialKind() == 7 && !this.okValueToCompareAgainst(n1)) {
                        if (this.priority != 1) {
                            this.found.clear();
                        }
                        this.priority = 1;
                        this.state = 1;
                        return;
                    }
                    if (this.priority == 1) {
                        return;
                    }
                    if (first.isInitialParameter() && n2 != null) {
                        return;
                    }
                    if (second.isInitialParameter() && n1 != null) {
                        return;
                    }
                    if (first.getRegisterNumber() == second.getRegisterNumber()) {
                        return;
                    }
                    if (first.isInitialParameter() && second.isInitialParameter()) {
                        return;
                    }
                    if (n1 != null && n2 != null) {
                        return;
                    }
                    if (this.okValueToCompareAgainst(n1)) return;
                    if (this.okValueToCompareAgainst(n2)) {
                        return;
                    }
                    if (n1 != null || n2 != null) {
                        if (this.priority == 3) {
                            this.found.clear();
                        }
                        this.priority = 2;
                    } else if (this.priority == 2) {
                        return;
                    }
                    this.state = 1;
                    return;
                }
                case 153: 
                case 154: {
                    SourceLineAnnotation sourceLineAnnotation;
                    if (this.state == 1 && (sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.getClassContext(), (PreorderVisitor)this, (int)this.getPC())) != null) {
                        this.found.add(sourceLineAnnotation);
                    }
                    this.state = 0;
                    return;
                }
            }
            this.state = 0;
            return;
        }
        finally {
            this.opStack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

