/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class SerialOutput
extends ObjectOutputStream {
    private static final byte[] STREAM_HEADER;
    private ClassCatalog classCatalog;

    public SerialOutput(OutputStream outputStream, ClassCatalog classCatalog) throws IOException {
        super(outputStream);
        this.classCatalog = classCatalog;
        this.useProtocolVersion(2);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        try {
            byte[] byArray = this.classCatalog.getClassID(objectStreamClass.getName());
            this.writeByte(byArray.length);
            this.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeExceptionWrapper(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeExceptionWrapper(classNotFoundException);
        }
    }

    public static byte[] getStreamHeader() {
        return STREAM_HEADER;
    }

    static {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SerialOutput serialOutput = new SerialOutput(byteArrayOutputStream, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        STREAM_HEADER = byteArrayOutputStream.toByteArray();
    }
}

