/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.swingui.table.DateTableCellRenderer;
import ca.sqlpower.architect.swingui.table.DecimalTableCellRenderer;
import ca.sqlpower.architect.swingui.table.PercentTableCellRenderer;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.architect.swingui.table.SQLObjectTableCellRenderer;
import ca.sqlpower.architect.swingui.table.TableModelSearchDecorator;
import ca.sqlpower.architect.swingui.table.TableModelSortDecorator;
import ca.sqlpower.architect.swingui.table.TableTextConverter;
import ca.sqlpower.architect.swingui.table.ValueTableCellRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ProfileTable
extends JTable
implements TableTextConverter {
    public ProfileTable(TableModel model) {
        super(model);
        TableColumnModel cm = this.getColumnModel();
        int col = 0;
        while (col < cm.getColumnCount()) {
            TableColumn tc = cm.getColumn(col);
            switch (ProfileColumn.values()[col]) {
                case DATABASE: 
                case CATALOG: 
                case SCHEMA: 
                case TABLE: 
                case COLUMN: {
                    tc.setCellRenderer(new SQLObjectTableCellRenderer());
                    break;
                }
                case RUNDATE: {
                    tc.setCellRenderer(new DateTableCellRenderer());
                    break;
                }
                case PERCENT_NULL: 
                case PERCENT_UNIQUE: {
                    tc.setCellRenderer(new PercentTableCellRenderer());
                    break;
                }
                case AVERAGE_LENGTH: {
                    tc.setCellRenderer(new DecimalTableCellRenderer());
                    break;
                }
                case MIN_VALUE: 
                case MAX_VALUE: 
                case AVERAGE_VALUE: 
                case TOP_VALUE: {
                    tc.setCellRenderer(new ValueTableCellRenderer());
                    break;
                }
                default: {
                    tc.setCellRenderer(null);
                }
            }
            ++col;
        }
    }

    public ColumnProfileResult getColumnProfileResultForRow(int row) {
        return (ColumnProfileResult)this.getModel().getValueAt(row, -1);
    }

    public TableModel getDataTableModel() {
        TableModelSortDecorator m1 = (TableModelSortDecorator)this.getModel();
        TableModelSearchDecorator m2 = (TableModelSearchDecorator)m1.getTableModel();
        ProfileTableModel m3 = (ProfileTableModel)m2.getTableModel();
        return m3;
    }

    public int modelIndex(int viewIndex) {
        TableModelSortDecorator m1 = (TableModelSortDecorator)this.getModel();
        return m1.modelIndex(viewIndex);
    }

    @Deprecated
    public void initColumnSizes() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.initSingleColumnSize(i);
            ++i;
        }
    }

    @Deprecated
    public void initSingleColumnSize(int colIndex) {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
        column = this.getColumnModel().getColumn(colIndex);
        comp = headerRenderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
        headerWidth = comp.getPreferredSize().width;
        int j = 0;
        while (j < this.getRowCount()) {
            comp = this.getCellRenderer(j, colIndex).getTableCellRendererComponent(this, this.getValueAt(j, colIndex), false, false, j, colIndex);
            cellWidth = Math.max(cellWidth, comp.getPreferredSize().width);
            ++j;
        }
        column.setPreferredWidth(Math.max(headerWidth, cellWidth));
    }

    public String getTextForCell(int row, int col) {
        JLabel renderer = (JLabel)this.getCellRenderer(row, col).getTableCellRendererComponent(this, this.getModel().getValueAt(row, this.getColumnModel().getColumn(col).getModelIndex()), false, false, row, col);
        return renderer.getText();
    }
}

