/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.ddl.ConflictResolver;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLWarning;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.NameChangeWarning;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.DDLExportPanel;
import ca.sqlpower.architect.swingui.MonitorableWorker;
import ca.sqlpower.architect.swingui.SQLScriptDialog;
import ca.sqlpower.architect.swingui.table.TableModelSortDecorator;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ExportDDLAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ExportDDLAction.class);
    protected ArchitectFrame architectFrame = ArchitectFrame.getMainInstance();
    private JDialog d;

    public ExportDDLAction() {
        super("Forward Engineer...", ASUtils.createIcon("ForwardEngineer", "Forward Engineer", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Forward Engineer SQL Script");
    }

    public void actionPerformed(ActionEvent e) {
        final DDLExportPanel ddlPanel = new DDLExportPanel(this.architectFrame.getProject());
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                block3: {
                    try {
                        GenericDDLGenerator ddlg;
                        block4: {
                            JTable warningTable;
                            int choice;
                            if (!ddlPanel.applyChanges()) break block3;
                            ddlg = ExportDDLAction.this.architectFrame.getProject().getDDLGenerator();
                            ddlg.setTargetSchema(ddlPanel.getSchemaField().getText());
                            do {
                                ddlg.generateDDL(ExportDDLAction.this.architectFrame.getProject().getPlayPen().getDatabase());
                                List warnings = ddlg.getWarnings();
                                if (warnings.size() == 0) break block4;
                                TableModelSortDecorator sorter = new TableModelSortDecorator(new DDLWarningTableModel(warnings));
                                warningTable = new JTable(sorter);
                                sorter.setTableHeader(warningTable.getTableHeader());
                            } while ((choice = JOptionPane.showConfirmDialog(ExportDDLAction.this.d, new JScrollPane(warningTable), "Errors in generated DDL", 2)) == 0);
                            return;
                        }
                        SQLDatabase ppdb = ArchitectFrame.getMainInstance().getProject().getPlayPen().getDatabase();
                        SQLScriptDialog ssd = new SQLScriptDialog(ExportDDLAction.this.d, "Preview SQL Script", "", false, (DDLGenerator)ddlg, ppdb.getDataSource(), true);
                        MonitorableWorker scriptWorker = ssd.getExecuteTask();
                        ConflictFinderProcess cfp = new ConflictFinderProcess(ssd, ppdb, ddlg, ddlg.getDdlStatements());
                        ConflictResolverProcess crp = new ConflictResolverProcess(ssd, cfp);
                        cfp.setNextProcess(crp);
                        crp.setNextProcess(scriptWorker);
                        ssd.setExecuteTask(cfp);
                        ssd.setVisible(true);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ExportDDLAction.this.architectFrame, "Can't export DDL: " + ex.getMessage());
                        logger.error((Object)"Got exception while exporting DDL", (Throwable)ex);
                    }
                }
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                ddlPanel.discardChanges();
                ExportDDLAction.this.d.setVisible(false);
            }
        };
        this.d = ArchitectPanelBuilder.createArchitectPanelDialog(ddlPanel, ArchitectFrame.getMainInstance(), "Forward Engineer SQL Script", "OK", okAction, cancelAction);
        this.d.pack();
        this.d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        this.d.setVisible(true);
    }

    public class ConflictFinderProcess
    extends MonitorableWorker {
        JDialog parentDialog;
        SQLDatabase target;
        DDLGenerator ddlg;
        List statements;
        ConflictResolver cr;
        String errorMessage;
        Throwable error;
        private boolean shouldDropConflicts;

        public ConflictFinderProcess(JDialog parentDialog, SQLDatabase target, DDLGenerator ddlg, List statements) throws ArchitectException, SQLException {
            this.parentDialog = parentDialog;
            this.target = target;
            this.ddlg = ddlg;
            this.statements = statements;
            this.cr = new ConflictResolver(target, ddlg, statements);
        }

        public boolean doesUserWantToDropConflicts() {
            return this.shouldDropConflicts;
        }

        public void doStuff() {
            if (this.isCanceled()) {
                return;
            }
            try {
                this.cr.findConflicting();
            }
            catch (Exception ex) {
                this.error = ex;
                this.errorMessage = "You have to specify a target database connection\nbefore executing this script.";
                logger.error((Object)"Unexpected exception setting up DDL generation", (Throwable)ex);
            }
        }

        public void cleanup() {
            if (!SwingUtilities.isEventDispatchThread()) {
                logger.error((Object)"runFinished is running on the wrong thread!");
            }
            if (this.errorMessage != null) {
                JOptionPane.showMessageDialog(this.parentDialog, this.errorMessage, "Error", 0);
            } else if (!this.cr.isEmpty()) {
                Object[] messages = new Object[3];
                messages[0] = "The following objects in the target database\nconflict with those you wish to create:";
                JTextArea conflictsPane = new JTextArea(this.cr.toConflictTree());
                conflictsPane.setRows(15);
                conflictsPane.setEditable(false);
                messages[1] = new JScrollPane(conflictsPane);
                messages[2] = "Do you want the Architect to drop these objects\nbefore attempting to create the new ones?";
                int choice = JOptionPane.showConfirmDialog(this.parentDialog, messages, "Conflicting Objects Found", 1);
                if (choice == 0) {
                    this.shouldDropConflicts = true;
                } else if (choice == 1) {
                    this.shouldDropConflicts = false;
                } else if (choice == 2) {
                    this.shouldDropConflicts = false;
                    this.setCancelled(true);
                }
            }
        }

        public ConflictResolver getConflictResolver() {
            return this.cr;
        }

        public Integer getJobSize() throws ArchitectException {
            return this.cr.getJobSize();
        }

        public String getMessage() {
            return this.cr.getMessage();
        }

        public int getProgress() throws ArchitectException {
            return this.cr.getProgress();
        }

        public boolean hasStarted() {
            return this.cr.hasStarted();
        }

        public boolean isFinished() throws ArchitectException {
            return this.cr.isFinished();
        }
    }

    public class ConflictResolverProcess
    extends MonitorableWorker {
        private JDialog parentDialog;
        private ConflictFinderProcess conflictFinder;
        private ConflictResolver cr;
        private String errorMessage;
        private Exception error;

        public ConflictResolverProcess(JDialog d, ConflictFinderProcess cfp) {
            this.parentDialog = d;
            this.conflictFinder = cfp;
        }

        public void doStuff() {
            if (this.isCanceled()) {
                return;
            }
            if (this.conflictFinder.doesUserWantToDropConflicts()) {
                this.cr = this.conflictFinder.getConflictResolver();
                this.cr.aboutToCallDropConflicting();
                try {
                    this.cr.dropConflicting();
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while dropping conflicting objects", (Throwable)ex);
                    this.errorMessage = "Error while dropping conflicting objects:\n\n" + ex.getMessage();
                }
            }
        }

        public void cleanup() {
            if (this.errorMessage != null) {
                ASUtils.showExceptionDialog(this.parentDialog, "Error Dropping Conflicts: " + this.errorMessage, this.error, new ArchitectExceptionReportFactory());
                this.setCancelled(true);
            }
        }

        public Integer getJobSize() throws ArchitectException {
            return this.cr.getJobSize();
        }

        public String getMessage() {
            return this.cr.getMessage();
        }

        public int getProgress() throws ArchitectException {
            return this.cr.getProgress();
        }

        public boolean hasStarted() {
            return this.cr.hasStarted();
        }

        public boolean isFinished() throws ArchitectException {
            return this.cr.isFinished();
        }
    }

    public static class DDLWarningTableModel
    extends AbstractTableModel {
        protected List warnings;

        public DDLWarningTableModel(List warnings) {
            this.warnings = warnings;
        }

        public int getRowCount() {
            return this.warnings.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Parent";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Warning Type";
                }
                case 3: {
                    return "Old Value";
                }
                case 4: {
                    return "New Value";
                }
            }
            throw new IndexOutOfBoundsException("Requested column name " + columnIndex + " of " + this.getColumnCount());
        }

        public Object getValueAt(int row, int column) {
            DDLWarning w = (DDLWarning)this.warnings.get(row);
            switch (column) {
                case 0: {
                    if (w.getSubject().getParent() == null) {
                        return "(No Parent)";
                    }
                    return w.getSubject().getParent().getParent();
                }
                case 1: {
                    return w.getSubject().getName();
                }
                case 2: {
                    return w.getReason();
                }
                case 3: {
                    return w.getOldValue();
                }
                case 4: {
                    return w.getNewValue();
                }
            }
            throw new IndexOutOfBoundsException("Requested column " + column + " of " + this.getColumnCount());
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            DDLWarning w = (DDLWarning)this.warnings.get(rowIndex);
            return w instanceof NameChangeWarning && columnIndex == 4;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DDLWarning w = (DDLWarning)this.warnings.get(rowIndex);
            if (columnIndex == 4) {
                w.setNewValue(aValue);
            }
            this.fireTableCellUpdated(rowIndex, 4);
        }
    }
}

