/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.TableEditPanel;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditTableAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(EditTableAction.class);
    protected PlayPen pp;
    protected DBTree dbt;
    private JDialog d;

    public EditTableAction() {
        super("Table Properties...", ASUtils.createIcon("TableProperties", "Table Properties", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Table Properties");
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("PlayPen")) {
            List<PlayPenComponent> selection = this.pp.getSelectedItems();
            if (selection.size() < 1) {
                JOptionPane.showMessageDialog(this.pp, "Select a table (by clicking on it) and try again.");
            } else if (selection.size() > 1) {
                JOptionPane.showMessageDialog(this.pp, "You have selected multiple items, but you can only edit one at a time.");
            } else if (selection.get(0) instanceof TablePane) {
                TablePane tp = (TablePane)selection.get(0);
                this.makeDialog(tp.getModel());
            } else {
                JOptionPane.showMessageDialog(this.pp, "The selected item type is not recognised");
            }
        } else if (evt.getActionCommand().equals("DBTree")) {
            TreePath[] selections = this.dbt.getSelectionPaths();
            logger.debug((Object)("selections length is: " + selections.length));
            if (selections.length != 1) {
                JOptionPane.showMessageDialog(this.dbt, "To indicate which table you like edit, please select a single table header.");
            } else {
                TreePath tp = selections[0];
                SQLObject so = (SQLObject)tp.getLastPathComponent();
                SQLTable st = null;
                if (so instanceof SQLTable) {
                    logger.debug((Object)"user clicked on table, so we shall try to edit the table properties.");
                    st = (SQLTable)so;
                    this.makeDialog(st);
                } else {
                    JOptionPane.showMessageDialog(this.dbt, "To indicate which table you like edit, please select a single table header.");
                }
            }
        }
    }

    private void makeDialog(SQLTable table) {
        final TableEditPanel editPanel = new TableEditPanel(table);
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                boolean success = editPanel.applyChanges();
                EditTableAction.this.d.setVisible(!success);
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                editPanel.discardChanges();
                EditTableAction.this.d.setVisible(false);
            }
        };
        this.d = ArchitectPanelBuilder.createArchitectPanelDialog(editPanel, ArchitectFrame.getMainInstance(), "Table Properties", "OK", okAction, cancelAction);
        this.d.pack();
        this.d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        this.d.setVisible(true);
    }

    public void setPlayPen(PlayPen pp) {
        this.pp = pp;
    }

    public void setDBTree(DBTree newDBT) {
        this.dbt = newDBT;
    }
}

